(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    181887,       6338]*)
(*NotebookOutlinePosition[    206603,       7209]*)
(*  CellTagsIndexPosition[    204733,       7149]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Computing with Harmonic Functions", "Title"],

Cell["Sheldon Axler", "Subtitle"],

Cell["9 August 2003\t\t\[Copyright] 2002 Sheldon Axler", "Text",
  TextAlignment->Center],

Cell[CellGroupData[{

Cell["Getting Started", "Section",
  CellTags->"Getting Started"],

Cell[CellGroupData[{

Cell["Harmonic Function Theory", "Subsection",
  CellTags->"Loading the Package"],

Cell[TextData[{
  "This notebook is the manual for HFT.m (version 6.10), a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " package for computing with harmonic functions. The HFT.m package allows \
the user to make calculations that would take a prohibitive amount of time if \
done without a computer. For example, the Poisson integral of any polynomial \
can be computed exactly."
}], "Text"],

Cell[TextData[{
  "Earlier versions of this software focused on algorithms arising from the \
material in the book ",
  StyleBox["Harmonic Function Theory",
    FontSlant->"Italic"],
  " [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "] by Sheldon Axler, Paul Bourdon, and Wade Ramey. That book is still the \
source for many of the algorithms used in the HFT.m package, but the goal of \
the package has expanded to include additional symbolic manipulations \
involving harmonic functions. The HFT.m package can be used without the ",
  StyleBox["Harmonic Function Theory",
    FontSlant->"Italic"],
  " book, but the debt to the book is reflected in the initials chosen for \
the name of the package."
}], "Text"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4.0 or a later version is needed to make use of HFT.m (version 6.01), \
which will work on any computer that runs ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "This notebook, the HFT.m package, and the HFT.nb notebook that serve as \
the source file fro the HFT.m package, are available electronically free of \
charge. To obtain the most recent versions, retrieve them using a World Wide \
Web browser from ",
  ButtonBox["http://www.axler.net",
    ButtonData:>{
      URL[ "http://math.sfsu.edu/axler"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[".", "html"]
}], "Text",
  TextAlignment->AlignmentMarker],

Cell[TextData[{
  "Comments, suggestions, and bug reports about this notebook, the HFT.m \
package, or the book ",
  StyleBox["Harmonic Function Theory",
    FontSlant->"Italic"],
  " are welcome; please send them via e-mail to axler@sfsu.edu."
}], "Text",
  TextAlignment->AlignmentMarker]
}, Closed]],

Cell[CellGroupData[{

Cell["Loading the Package", "Subsection",
  CellTags->"Loading the Package"],

Cell[TextData[{
  "To begin a session with the HFT.m package, first start ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Then enter the command shown below, making an appropriate modification \
to indicate the directory or folder in which HFT.m is located on your \
computer. After typying <<, you can use the Get File Path command, located in \
the Input menu, to paste the full pathname of HFT.m into your input cell:"
}], "Text",
  TextAlignment->AlignmentMarker],

Cell[CellGroupData[{

Cell[BoxData[
    \(<< "\<C:\\math\\publications\\HFT-Mathematica\\HFT.m\>"\)], "Input"],

Cell[BoxData[
    \("HFT; Version 6.10, 9 August 2003"\)], "Print"],

Cell[BoxData[
    \("This Mathematica package, called HFT.m, is designed for computing with \
harmonic functions. Documentation for the use of this package and information \
about the algorithms used in it is available in the Mathematica notebook \
called HFT.nb."\)], "Print"],

Cell[BoxData[
    \("For addional information about harmonic functions, see the book \
Harmonic Function Theory, by Sheldon Axler, Paul Bourdon, and Wade Ramey, \
published by Springer."\)], "Print"],

Cell[BoxData[
    \("This package is copyrighted by Sheldon Axler but is distributed \
without charge. The most recent version of this HFT.m package along with its \
documentation notebook HFT.nb is available over the world wide web at: \
http://www.axler.net"\)], "Print"],

Cell[BoxData[
    \("Comments, suggestions, and bug reports should be sent by electronic \
mail to: axler@sfsu.edu"\)], "Print"],

Cell[BoxData[
    \("* The computer is now unpacking the HFT.m package."\)], "Print"],

Cell[BoxData[
    \("* You can now use the functions in this package."\)], "Print"]
}, Closed]],

Cell["\<\
After loading the HFT.m package, you can use the functions \
described in the rest of this notebook.\
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["On-line Help", "Subsection",
  CellTags->"On-line Help"],

Cell["\<\
This notebook provides the only complete documentation for using \
the HFT.m package. However, users can be reminded about the basic use and \
syntax of each function created by HFT.m by entering ? followed by the \
function name:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?Volume\)\)], "Input"],

Cell[BoxData[
    \("Volume[n] gives the volume of the unit ball in n-dimensional real \
Euclidean space."\)], "Print",
  CellTags->"Info3269422509-9203424"]
}, Closed]],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " statement Names[\"HFT`*\"] will produce a complete list of the functions \
created by HFT.m:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Names["\<HFT`*\>"]\)], "Input"],

Cell[BoxData[
    \({"Annulus", "AntiLaplacian", "Ball", "BasisH", "BergmanKernel", 
      "BergmanKernelH", "BergmanProjection", "BiDirichlet", "Delta", 
      "Dimension", "DimensionH", "Dirichlet", "Divergence", 
      "DoubleBracketingBar", "ExpandNorm", "ExteriorNeumann", 
      "ExteriorSphere", "Grad", "HarmonicConjugate", "HarmonicDecomposition", 
      "HilbertSchmidt", "Homogeneous", "Hyperplane", "IntegrateBall", 
      "IntegrateSphere", "J", "Kelvin", "KelvinM", "Laplacian", "Multiple", 
      "Neumann", "NormalD", "Orthonormal", "Partial", "PoissonKernel", 
      "PoissonKernelH", "Quadratic", "Reflection", "Region", "S", "Schwarz", 
      "SetDimension", "Singularity", "Sphere", "SurfaceArea", "Taylor", 
      "Togetherness", "TurnOff", "TurnOn", "Volume", "ZeroToZero", 
      "ZonalHarmonic", "\[CapitalPhi]"}\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Calculus in ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontSlant->"Plain"], "n"], TraditionalForm]]]
}], "Section",
  CellTags->"Calculus in R^n"],

Cell[CellGroupData[{

Cell["Norm", "Subsection",
  CellTags->"Norm"],

Cell[TextData[{
  StyleBox["Norm[x]", "InlineInput"],
  " is the Euclidean norm of a vector ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". When using StandardForm for output (which is the default in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "), this package will use ",
  StyleBox["\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]", 
    "InlineInput"],
  " instead of ",
  StyleBox["Norm[x]", "InlineInput"],
  ". When using StandardForm for input (which is the default in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "), you can use either ",
  StyleBox["\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]", 
    "InlineInput"],
  " or ",
  StyleBox["Norm[x]", "InlineInput"],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[LeftDoubleBracketingBar]5\ x\[RightDoubleBracketingBar]\  - 
      Norm[2  x]\^2\)], "Input"],

Cell[BoxData[
    \(5\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar] - 
      4\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\)], \
"Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["ExpandNorm", "Subsection",
  CellTags->"ExpandNorm"],

Cell[TextData[{
  StyleBox["ExpandNorm", "InlineInput"],
  " expands norms of sums (and differences) by replacing expressions of the \
form ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftDoubleBracketingBar]x + 
          y\[RightDoubleBracketingBar]\)]],
  " with (",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2 + \[LeftDoubleBracketingBar]y\
\[RightDoubleBracketingBar]\^2\)]],
  "+ ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(x . y\)\()\)\)\^\(1/2\)\)]],
  ". ",
  StyleBox["ExpandNorm", "InlineInput"],
  " is often useful for verifying identities. For example, to prove the \
Symmetry Lemma (1.13 in [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "]), which states that"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\[LeftDoubleBracketingBar]y\/\[LeftDoubleBracketingBar]\
y\[RightDoubleBracketingBar] - \[LeftDoubleBracketingBar]y\
\[RightDoubleBracketingBar]\ x\[RightDoubleBracketingBar] = \
\[LeftDoubleBracketingBar]x\/\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar] - \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\ y\[RightDoubleBracketingBar]\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  " for all nonzero ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " \[Epsilon] ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontWeight->"Bold",
            FontSlant->"Plain"], "n"], TraditionalForm]]],
  ", we subtract the left-hand side of the alleged equality from the \
right-hand side, hoping that the result equals 0:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[LeftDoubleBracketingBar]x\/\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar] - \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\ y\[RightDoubleBracketingBar] - \
\[LeftDoubleBracketingBar]y\/\[LeftDoubleBracketingBar]y\
\[RightDoubleBracketingBar] - \[LeftDoubleBracketingBar]y\
\[RightDoubleBracketingBar]\ x\[RightDoubleBracketingBar]\)], "Input"],

Cell[BoxData[
    \(\[LeftDoubleBracketingBar]x\/\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar] - 
          y\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\
\[RightDoubleBracketingBar] - \[LeftDoubleBracketingBar]y\/\
\[LeftDoubleBracketingBar]y\[RightDoubleBracketingBar] - 
          x\ \[LeftDoubleBracketingBar]y\[RightDoubleBracketingBar]\
\[RightDoubleBracketingBar]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The last output does not look like 0, so we apply ",
  StyleBox["ExpandNorm", "InlineInput"],
  " to it. The symbol ",
  StyleBox["%", "InlineInput"],
  " used below is the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " abbreviation for the last output:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExpandNorm[%]\)], "Input"],

Cell[BoxData[
    \(0\)], "Output"]
}, Closed]],

Cell["\<\
Because the last output equals 0, the Symmetry Lemma has been \
proved.\
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Partial", "Subsection",
  CellTags->"Partial"],

Cell[TextData[{
  StyleBox["Partial[f, ", "InlineInput"],
  StyleBox[Cell[BoxData[
      \(x\_j\)], "InlineInput"], "InlineInput"],
  StyleBox["]", "InlineInput"],
  " is the partial derivative of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`x\_j\)]],
  ". Here ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " denotes a vector in Euclidean space, and ",
  Cell[BoxData[
      \(TraditionalForm\`x\_j\)]],
  " is the ",
  Cell[BoxData[
      \(TraditionalForm\`j\^th\)]],
  " coordinate of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". The advantage of using ",
  StyleBox["Partial", "InlineInput"],
  " rather than the built-in ",
  Cell[BoxData[
      \(TraditionalForm\`Mathematica\)]],
  " function ",
  StyleBox["D", "InlineInput"],
  " or ",
  Cell[BoxData[
      FormBox[
        StyleBox["\[PartialD]",
          "InlineInput"], TraditionalForm]]],
  " is that ",
  StyleBox["Partial", "InlineInput"],
  " can deal with norms and dot products.  Note that the dot product of ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " is  denoted by ",
  StyleBox["b.x", "InlineInput"],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partial[\[LeftDoubleBracketingBar]a + x\[RightDoubleBracketingBar]\^\(b \
. x\), x\_5]\)], "Input"],

Cell[BoxData[
    \(Log[\[LeftDoubleBracketingBar]a + 
              x\[RightDoubleBracketingBar]]\ \[LeftDoubleBracketingBar]a + x\
\[RightDoubleBracketingBar]\^\(b . x\)\ b\_5 + 
      b . x\ \[LeftDoubleBracketingBar]a + \
x\[RightDoubleBracketingBar]\^\(\(-2\) + b . x\)\ \((a\_5 + 
            x\_5)\)\)], "Output"]
}, Closed]],

Cell[TextData[{
  "A subscript can be typed in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " by pressing control-dash. Return to normal mode by pressing \
control-space. A suberscript or exponent can be typed by pressing control-6. \
Instead of entering ",
  Cell[BoxData[
      StyleBox[\(x\_j\),
        "InlineInput"]]],
  ", you can type ",
  StyleBox["x[j]", "InlineInput"],
  "."
}], "Text"],

Cell[TextData[{
  "For taking multiple partial derivatives, ",
  StyleBox["Partial", "InlineInput"],
  " uses the same syntax as the built-in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function ",
  StyleBox["D", "InlineInput"],
  ". For example, the following command computes the partial derivative of \
|",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "| once with respect to the second coordinate, twice with respect to the \
first coordinate and three times with respect to thefourth coordinate:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partial[\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar], 
      x\_2, {x\_1, 2}, {x\_4, 3}]\)], "Input"],

Cell[BoxData[
    \(\(-\(\(15\ \((3\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\
\^4\ x\_2\ x\_4 - 
                21\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\
\ x\_1\%2\ x\_2\ x\_4 - 
                7\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ \
x\_2\ x\_4\%3 + 
                63\ x\_1\%2\ x\_2\ x\_4\%3)\)\)\/\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^11\)\)\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Laplacian", "Subsection",
  CellTags->"Laplacian"],

Cell[TextData[{
  StyleBox["Laplacian[f, x]", "InlineInput"],
  " is the Laplacian of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Laplacian[x\_3\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar], 
      x]\)], "Input"],

Cell[BoxData[
    \(\(x\_3 + Dimension[x]\ x\_3\)\/\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Note that in the last result, the Laplacian depends upon ",
  StyleBox["Dimension[x]", "Output"],
  ", which is the dimension of the Euclidean space in which ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " lives.  For work in ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontWeight->"Bold",
            FontSlant->"Plain"], "n"], TraditionalForm]]],
  ", ",
  StyleBox["SetDimension[x, n]", "InlineInput"],
  " should be used to set the dimension of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " equal to ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "; here ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " can be a symbol or a specific integer, say 8. We illustrate this \
procedure by showing that for each ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  " with |",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  "| = 1, the Poisson kernel ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  "(. , ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  ") is harmonic (in other words, what follows is a proof of Proposition 1.18 \
of [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "]):"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDimension[x, n]\)], "Input"],

Cell[BoxData[
    \(SetDimension::"Vector" \(\(:\)\(\ \)\) 
      "\!\(x\) will be considered to be a vector in \!\(n\)-dimensional real \
Euclidean space."\)], "Message"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Laplacian[\((1 - \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\
\^2)\)/\[LeftDoubleBracketingBar]x - z\[RightDoubleBracketingBar]\^n, 
      x]\)], "Input"],

Cell[BoxData[
    \(4\ n\ \((\(-x . 
                z\) + \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^\
2)\)\ \[LeftDoubleBracketingBar]x - z\[RightDoubleBracketingBar]\^\(\(-2\) - \
n\) - 2\ n\ \[LeftDoubleBracketingBar]x - \
z\[RightDoubleBracketingBar]\^\(-n\) + \((1 - \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2)\)\ \((\(-\((\(-1\) + 
                    n)\)\)\ n\ \[LeftDoubleBracketingBar]x - z\
\[RightDoubleBracketingBar]\^\(\(-2\) - n\) - 
            n\ \((1 + 
                  n)\)\ \[LeftDoubleBracketingBar]x - z\
\[RightDoubleBracketingBar]\^\(\(-4\) - n\)\ \((2\ x . 
                      z - \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2 - \[LeftDoubleBracketingBar]z\
\[RightDoubleBracketingBar]\^2)\))\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExpandNorm[%]\  /. \ Norm[z] \[Rule] 1\)], "Input"],

Cell[BoxData[
    \(0\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Thus the Laplacian of ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  "(. , ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  ") is 0, and hence ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  "(. , ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  ") is harmonic, as claimed."
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        StyleBox[
          SuperscriptBox["Laplacian", 
            StyleBox["m",
              FontSlant->"Plain"]],
          "InlineInput"], TraditionalForm]]],
  " can be used, with the same syntax as Laplacian, to evaluate the ",
  Cell[BoxData[
      \(TraditionalForm\`m\^th\)]],
  " power of the Laplacian. For example, here we find the biLaplacian (the \
Laplacian of the Laplacian) of 1/|",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "| on ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontWeight->"Bold",
            FontSlant->"Plain"], "n"], TraditionalForm]]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Laplacian\^2\)[
      1/\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar], x]\)], "Input"],

Cell[BoxData[
    \(\(3\ \((15 - 8\ n + n\^2)\)\)\/\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^5\)], "Output"]
}, Closed]],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " are symbols,then ",
  StyleBox["Laplacian[f,x,y]", "InlineInput"],
  " gives the Laplacian of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " with respect to the vector (",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  "), where ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " is thought of as a vector, ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " is thought of as a real variable, and (",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  ") is thought of as a vector in a Euclidean space whose dimension is one \
more than the dimension of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ".This format is often useful when working with functions defined on the \
upper half-space, as in Chapter 7 of [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "].Note that if we are thinking of (",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  ") as an element of ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontWeight->"Bold",
            FontSlant->"Plain"], "n"], TraditionalForm]]],
  ", then ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " should be defined to have dimension ",
  Cell[BoxData[
      \(TraditionalForm\`n - 1\)]],
  ". We illustrate the use of this format of the ",
  StyleBox["Laplacian", "InlineInput"],
  " function by showing that for each ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " \[Epsilon] ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontWeight->"Bold",
            FontSlant->"Plain"], \(n - 1\)], TraditionalForm]]],
  ", the Poisson kernel ",
  Cell[BoxData[
      \(TraditionalForm\`P\_H\)]],
  "(,. ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ") for the upper half-space is harmonic (see page 145 of [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "] for another proof of this):"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDimension[x, n - 1]\)], "Input"],

Cell[BoxData[
    \(SetDimension::"Vector" \(\(:\)\(\ \)\) 
      "\!\(x\) will be considered to be a vector in \!\(\(\(-1\)\) + \
n\)-dimensional real Euclidean space."\)], "Message"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Laplacian[
      y/\((\[LeftDoubleBracketingBar]x - t\[RightDoubleBracketingBar]\^2 + \
y\^2)\)\^\(n/2\), x, y]\)], "Input"],

Cell[BoxData[
    \(\(-\(\(n\ y\ \((y\^2 + \[LeftDoubleBracketingBar]\(-t\) + x\
\[RightDoubleBracketingBar]\^2)\)\^\(\(-2\) - n\/2\)\ \((2\ t . 
                    x - \[LeftDoubleBracketingBar]t\[RightDoubleBracketingBar]\
\^2 - \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2 + \
\[LeftDoubleBracketingBar]\(-t\) + x\[RightDoubleBracketingBar]\^2)\)\ \
\((\(-y\^2\) + \[LeftDoubleBracketingBar]\(-t\) + \
x\[RightDoubleBracketingBar]\^2 + 
                n\ \[LeftDoubleBracketingBar]\(-t\) + x\
\[RightDoubleBracketingBar]\^2)\)\)\/\[LeftDoubleBracketingBar]\(-t\) + x\
\[RightDoubleBracketingBar]\^2\)\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExpandNorm[%]\)], "Input"],

Cell[BoxData[
    \(0\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Thus the Laplacian of ",
  Cell[BoxData[
      \(TraditionalForm\`P\_H\)]],
  "(,. ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ") is 0, and hence ",
  Cell[BoxData[
      \(TraditionalForm\`P\_H\)]],
  "(,. ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ") is harmonic, as claimed."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Grad", "Subsection",
  CellTags->"Grad"],

Cell[TextData[{
  StyleBox["Grad[f, x]", "InlineInput"],
  " is the gradient of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " with respect to the vector ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " (",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "'s convention of spelling out names in full would imply that this function \
should be called ",
  StyleBox["Gradient", "InlineInput"],
  " instead of ",
  StyleBox["Grad", "InlineInput"],
  ", but ",
  StyleBox["Gradient", "InlineInput"],
  " is already used by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " for an unrelated purpose):"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Grad[
      a . x + x\_k + \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar], 
      x]\)], "Input"],

Cell[BoxData[
    \(a + Delta[k] + 
      x\/\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "In the last output, ",
  StyleBox["Delta[k]", "Output"],
  " denotes the vector that equals 1 in the ",
  Cell[BoxData[
      \(TraditionalForm\`k\^th\)]],
  " coordinate and 0 in the other coordinates."
}], "Text",
  CellTags->"Delta"]
}, Closed]],

Cell[CellGroupData[{

Cell["NormalD", "Subsection",
  CellTags->"NormalD"],

Cell[TextData[{
  StyleBox["NormalD[f, z]", "InlineInput"],
  " equals the outward normal derivative of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " at a point ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  " on the unit sphere."
}], "Text"],

Cell[TextData[{
  "In the section of Chapter 1 of [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "] titled ",
  StyleBox["The Poisson Kernel for the Ball",
    FontSlant->"Italic"],
  ", the formula for the Poisson kernel was derived by showing that ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  "(",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ",\[NonBreakingSpace]",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  ") equals the normal derivative (with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  ") of"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\((\[LeftDoubleBracketingBar]z - x\
\[RightDoubleBracketingBar]\^\(2 - n\) - \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^\(2 - n\)\ \[LeftDoubleBracketingBar]z - x\/\
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\
\[RightDoubleBracketingBar]\^\(2 - n\))\)/\(\((2 - n)\)\(.\)\)\)], "Text",
  TextAlignment->Center],

Cell["\<\
The computation of that normal derivative is a bit complicated and \
was left to the reader. Now we show how this computation can be done easily \
by a computer. We begin by taking the normal derivative of the function \
above:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NormalD[\((\[LeftDoubleBracketingBar]z - x\[RightDoubleBracketingBar]\^\
\(2 - n\) - \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^\(2 - n\)\
\ \[LeftDoubleBracketingBar]z - x\/\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2\[RightDoubleBracketingBar]\^\(2 - n\))\)/\((2 \
- n)\), z]\)], "Input"],

Cell[BoxData[
    \(\(\((2 - n)\)\ \((1 - x . z)\)\ \[LeftDoubleBracketingBar]\(-x\) + z\
\[RightDoubleBracketingBar]\^\(-n\) - \((\(-2\) + n)\)\ \
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^\(-n\)\ \((x . z - \
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2)\)\ \
\[LeftDoubleBracketingBar]z - x\/\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2\[RightDoubleBracketingBar]\^\(-n\)\)\/\(2 - \
n\)\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Now we ask the computer to replace ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftDoubleBracketingBar]z - 
          x\/\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\
\[RightDoubleBracketingBar]\)]],
  " in the last output with ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftDoubleBracketingBar]z - 
            x\[RightDoubleBracketingBar]/\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\)]],
  "; the Symmetry Lemma (1.13 of [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "]) implies that  the two expressions are equal:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(%\  /. \[LeftDoubleBracketingBar]z - 
            x\/\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\
\[RightDoubleBracketingBar] \[Rule] \[LeftDoubleBracketingBar]z - 
              x\[RightDoubleBracketingBar]/\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\)], "Input"],

Cell[BoxData[
    \(\(\((2 - n)\)\ \((1 - x . z)\)\ \[LeftDoubleBracketingBar]\(-x\) + z\
\[RightDoubleBracketingBar]\^\(-n\) + \((\(-2\) + n)\)\ \
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^\(-n\)\ \((\(-x . z\) \
+ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2)\)\ \((\
\[LeftDoubleBracketingBar]\(-x\) + z\[RightDoubleBracketingBar]\/\
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar])\)\^\(-n\)\)\/\(2 - \
n\)\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Applying the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function ",
  StyleBox["PowerExpand", "InlineInput"],
  " to the last output gives the desired result:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PowerExpand[%]\)], "Input"],

Cell[BoxData[
    \(\(-\((\(-1\) + \
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2)\)\)\ \
\[LeftDoubleBracketingBar]\(-x\) + z\[RightDoubleBracketingBar]\^\(-n\)\)], \
"Output"]
}, Closed]],

Cell["\<\
The last output completes the derivation of the formula for the \
Poisson kernal for the ball.\
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Matrices", "Subsection",
  CellTags->"Matrices"],

Cell[CellGroupData[{

Cell["Matrix dimensions", "Subsubsection"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses ",
  StyleBox[".", "InlineInput"],
  " to represent matrix multiplication as well as dot product.  When using \
this package, you must use the ",
  StyleBox["SetDimension", "InlineInput"],
  " command to tell ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "whenever a symbol is being thought of as a matrix. To think of ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " as an ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  "-by-",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " matrix, enter the command ",
  StyleBox["SetDimension[A, {m, n}]", "InlineInput"],
  ". For the examples in this section, we want to think of ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " as a square matrix, so we make the two dimensions of ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " equal:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDimension[A, \ {n, n}]\)], "Input"],

Cell[BoxData[
    \(SetDimension::"Matrix" \(\(:\)\(\ \)\) 
      "\!\(A\) will be considered to be a matrix of size \!\(n\)-by-\!\(n\)."\
\)], "Message"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Grad[\[LeftDoubleBracketingBar]A . x\[RightDoubleBracketingBar], 
      x]\)], "Input"],

Cell[BoxData[
    \(\((A . x)\) . A\/\[LeftDoubleBracketingBar]A . x\
\[RightDoubleBracketingBar]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To interpret input or output involving products of matrices and vectors, \
think of vectors as either column vectors or row vectors, whichever makes \
sense in context. Thus in the input above, ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " is obviously a vector, because we are taking the gradient of some \
function with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". For ",
  Cell[BoxData[
      \(TraditionalForm\`A . x\)]],
  " to make sense as a vector in ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontWeight->"Bold",
            FontSlant->"Plain"], "n"], TraditionalForm]]],
  ", we must think of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " as a column vector (an ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "-by-1 matrix).  To interpret ",
  Cell[BoxData[
      \(TraditionalForm\`\((A . x)\) . A\)]],
  " in the last output, we again think of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " as a column vector (an ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "-by-1 matrix), so that ",
  Cell[BoxData[
      \(TraditionalForm\`A . x\)]],
  " makes sense as an element of ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontWeight->"Bold",
            FontSlant->"Plain"], "n"], TraditionalForm]]],
  ".  Because ",
  Cell[BoxData[
      \(TraditionalForm\`A . x\)]],
  " is then multiplied by the ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "-by-",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " matrix ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  ", we must think of ",
  Cell[BoxData[
      \(TraditionalForm\`A . x\)]],
  " as a row vector (an 1-by-",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " matrix), so that ",
  Cell[BoxData[
      \(TraditionalForm\`\((A . x)\) . A\)]],
  " is a vector, as expected here (because it is the gradient of a \
function)."
}], "Text"],

Cell[TextData[{
  "In the example above we did not enter the command ",
  StyleBox["SetDimension[x, n]", "InlineInput"],
  " to tell ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " that ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " is a vector (although it would not have hurt to do so). The HFT.m package \
can almost always use the context to distinguish scalars from vectors (if \
both interpretations make sense, the package assumes that a symbol represents \
a scalar).  However, you must always explicitly use the ",
  StyleBox["SetDimension", "InlineInput"],
  " command to tell ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " which objects are matrices."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Rows and columns", "Subsubsection"],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " is a matrix, then ",
  Cell[BoxData[
      \(TraditionalForm\`A\_\(j,  . \)\)]],
  " denotes the ",
  Cell[BoxData[
      \(TraditionalForm\`j\^th\)]],
  " row of ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`A\_\(\(.\)\(\(,\)\(j\)\)\)\)]],
  " denotes the ",
  Cell[BoxData[
      \(TraditionalForm\`j\^th\)]],
  " column of ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partial[\[LeftDoubleBracketingBar]A . x\[RightDoubleBracketingBar] + 
        5 \[LeftDoubleBracketingBar]x . A\[RightDoubleBracketingBar], 
      x\_3]\)], "Input"],

Cell[BoxData[
    \(\((A . x)\) . A\_\(".", 3\)\/\[LeftDoubleBracketingBar]A . x\
\[RightDoubleBracketingBar] + \(5\ \((x . A)\) . A\_\(3, "."\)\)\/\
\[LeftDoubleBracketingBar]x . A\[RightDoubleBracketingBar]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Note that in the input above, ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " is thought of as a column vector in the term ",
  Cell[BoxData[
      \(TraditionalForm\`A . x\)]],
  " and as a row vector in the term ",
  Cell[BoxData[
      \(TraditionalForm\`x . A\)]],
  ".  To interpret ",
  Cell[BoxData[
      \(TraditionalForm\`\((A . x)\) . A\_\(\(.\)\(\(,\)\(3\)\)\)\)]],
  " in the last output, we think of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " as a column vector, so that ",
  Cell[BoxData[
      \(TraditionalForm\`A . x\)]],
  " is a vector.  Then ",
  Cell[BoxData[
      \(TraditionalForm\`\((A . x)\) . A\_\(\(.\)\(\(,\)\(3\)\)\)\)]],
  " is just the dot product of two vectors, so that it is a number, as \
expected here."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["HilbertSchmidt", "Subsubsection"],

Cell[TextData[{
  StyleBox["HilbertSchmidt[A]", "InlineInput"],
  " is the Hilbert-Schmidt norm of a matrix ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  ", which is the square root of the sum of the squares of all entries of ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Laplacian[\[LeftDoubleBracketingBar]x . A\[RightDoubleBracketingBar], 
      x]\)], "Input"],

Cell[BoxData[
    \(\(HilbertSchmidt[A]\^2\ \[LeftDoubleBracketingBar]x . A\
\[RightDoubleBracketingBar]\^2 - \[LeftDoubleBracketingBar]x . A . \
Transpose[A]\[RightDoubleBracketingBar]\^2\)\/\[LeftDoubleBracketingBar]x . A\
\[RightDoubleBracketingBar]\^3\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Here ",
  StyleBox["Transpose[A]", "Output"],
  " is the matrix obtained from ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " by interchanging the rows and columns of ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  "."
}], "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Divergence", "Subsection",
  CellTags->"Divergence"],

Cell[TextData[{
  StyleBox["Divergence[f, x]", "InlineInput"],
  " is the divergence of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " with respect to the vector ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDimension[A, \ {n, n}]\)], "Input"],

Cell[BoxData[
    \(SetDimension::"Matrix" \(\(:\)\(\ \)\) 
      "\!\(A\) will be considered to be a matrix of size \!\(n\)-by-\!\(n\)."\
\)], "Message"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Divergence[
      A . x/\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar], 
      x]\)], "Input"],

Cell[BoxData[
    \(\(-\(x . \((A . 
                  x)\)\/\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\
\^3\)\) + 
      Tr[A]\/\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\)], \
"Output"]
}, Closed]],

Cell["Here Tr[A] is the trace of the square matrix A.", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["J", "Subsection",
  CellTags->"J"],

Cell[TextData[{
  StyleBox["J[f, x]", "InlineInput"],
  " is the Jacobian derivative of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". Here ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " should be a function of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " taking values in some Euclidean space, and the Jacobian derivative is the \
usual matrix consisting of partial derivatives of the coordinates of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " (",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "'s convention of spelling out names in full would imply that this function \
should be called ",
  StyleBox["Jacobian", "InlineInput"],
  " instead of ",
  StyleBox["J", "InlineInput"],
  ", but ",
  StyleBox["Jacobian", "InlineInput"],
  " is already used by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " for an unrelated purpose):"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDimension[x, n]\)], "Input"],

Cell[BoxData[
    \(SetDimension::"Vector" \(\(:\)\(\ \)\) 
      "\!\(x\) will be considered to be a vector in \!\(n\)-dimensional real \
Euclidean space."\)], "Message"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(J[x/\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2, 
      x]\)], "Input"],

Cell[BoxData[
    \(\(-\(\(2\ Transpose[{x}] . {x}\)\/\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^4\)\) + 
      IdentityMatrix[n]\/\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Although ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " can be thought of as a row vector or a column vector, depending on the \
context, if we were using explicit coordinates we would represent ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " by something like ",
  Cell[BoxData[
      StyleBox[\({x\_1, x\_2,  ... \ , \ x\_n}\),
        "InlineInput"]]],
  ".  Thus ",
  StyleBox["{x}", "InlineInput"],
  " would be ",
  Cell[BoxData[
      FormBox[
        StyleBox[\({{x\_1, x\_2,  ... \ , \ x\_n}}\),
          "InlineInput"], InputForm]]],
  ", which is a 1-by-",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " matrix.  Thus ",
  StyleBox["Transpose[{x}]", "InlineInput"],
  " is an ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "-by-1 matrix, and the product ",
  StyleBox["Transpose[{x}].{x}", "Output"],
  ", which appears in the last output, is an ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "-by-",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " matrix, as expected."
}], "Text"],

Cell[TextData[{
  StyleBox["IdentityMatrix[n]", "Output"],
  ", which also appears in the last output, denotes the ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "-by-",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " matrix with 1's on the diagonal and 0's elsewhere."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Homogeneous", "Subsection",
  CellTags->"Homogeneous"],

Cell[TextData[{
  StyleBox["Homogeneous[u, m, x]", "InlineInput"],
  " is the term of degree ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " in the homogeneous expansion of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " at the origin; here ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " is thought of as a function of the vector ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDimension[x, 3]\)], "Input"],

Cell[BoxData[
    \(SetDimension::"Vector" \(\(:\)\(\ \)\) 
      "\!\(x\) will be considered to be a vector in \!\(3\)-dimensional real \
Euclidean space."\)], "Message"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(Homogeneous[\((1 - \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2)\)/Cos[x\_1]\^\(3/2\), 4, x]\)\(\n\)
    \)\)], "Input"],

Cell[BoxData[
    \(1\/32\ \((\(-11\)\ x\_1\%4 - 24\ x\_1\%2\ x\_2\%2 - 
          24\ x\_1\%2\ x\_3\%2)\)\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To find homogeneous expansions about points other than the origin, use ",
  StyleBox["Homogeneous[u, m, x, b]", "InlineInput"],
  ", which gives the term of degree ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " in the homogeneous expansion of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ", as a function of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", about ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Homogeneous[x\_1\ x\_2 + x\_3\^4, 2, x, b]\)], "Input"],

Cell[BoxData[
    \(Togetherness::"Off" \(\(:\)\(\ \)\) 
      "Togetherness has been turned off.  The command  TurnOn[Togetherness]  \
will turn it back on."\)], "Message"],

Cell[BoxData[
    \(\((\(-b\_1\) + x\_1)\)\ \((\(-b\_2\) + x\_2)\) + 
      6\ b\_3\%2\ \((\(-b\_3\) + x\_3)\)\^2\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The first time in each ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " session that you use ",
  StyleBox["Homogeneous", "InlineInput"],
  " to find an expansion about a point other than the origin, you may see a \
message that ",
  StyleBox["Togetherness", "Output"],
  " has been turned off.  The ",
  ButtonBox["Togetherness",
    ButtonData:>"TurnOff and TurnOn",
    ButtonStyle->"Hyperlink"],
  " subsection later in this notebook provides an explanation for this \
message."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Taylor", "Subsection",
  CellTags->"Taylor"],

Cell[TextData[{
  StyleBox["Taylor[u, m, x]", "InlineInput"],
  " is the sum of all terms of degree at most ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " in the Taylor series expansion of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " at the origin; here ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " is thought of as a function of the vector ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(Taylor[x\_1\^2/\((6 + x\_2 + Cos[x\_3])\), 4, x]\)\(\n\)
    \)\)], "Input"],

Cell[BoxData[
    \(x\_1\%2\/7 - 1\/49\ x\_1\%2\ x\_2 + 1\/343\ x\_1\%2\ x\_2\%2 + 
      1\/98\ x\_1\%2\ x\_3\%2\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To find Taylor series expansions about points other than the origin, use \
",
  StyleBox["Taylor[u, m, x, b]", "InlineInput"],
  ", which gives the sum of all terms of degree at most ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " in the Taylor series expansion of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ", as a function of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", about ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Taylor[1 + x\_1\ x\_2 + x\_1\^2, 2, x, b]\)], "Input"],

Cell[BoxData[
    \(1 + b\_1\%2 + 
      b\_1\ b\_2 + \((2\ b\_1 + b\_2)\)\ \((\(-b\_1\) + 
            x\_1)\) + \((\(-b\_1\) + x\_1)\)\^2 + 
      b\_1\ \((\(-b\_2\) + x\_2)\) + \((\(-b\_1\) + x\_1)\)\ \((\(-b\_2\) + 
            x\_2)\)\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The first time in each ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " session that you use ",
  StyleBox["Taylor", "InlineInput"],
  " to find an expansion about a point other than the origin, you may see a \
message that ",
  StyleBox["Togetherness", "Output"],
  " has been turned off.  The ",
  ButtonBox["Togetherness",
    ButtonData:>"TurnOff and TurnOn",
    ButtonStyle->"Hyperlink"],
  " subsection later in this notebook provides an explanation for this \
message. ",
  "For now, we turn ",
  StyleBox["Togetherness", "Output"],
  " back on so that further output in this notebook will be displayed \
nicely."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TurnOn[Togetherness]\)], "Input"],

Cell[BoxData[
    \(Togetherness::"On" \(\(:\)\(\ \)\) 
      "Togetherness has been turned on.  The command  TurnOff[Togetherness]  \
will turn it back off."\)], "Message"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Nonexplicit functions", "Subsection",
  CellTags->"Nonexplicit Functions"],

Cell[TextData[{
  "Our examples so far have involved only concretely defined functions.  But \
functions in symbolic form can also be used with each of the differentiation \
commands in this package. Here, for example, is how to find the gradient of \
the function whose value at ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " is ",
  Cell[BoxData[
      \(TraditionalForm\`f(\((g(3  x))\)\^2)\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Grad[f[g[3  x]\^2], x]\)], "Input"],

Cell[BoxData[
    RowBox[{"6", " ", \(g[3\ x]\), " ", \(\(Grad[g]\)[3\ x]\), " ", 
      RowBox[{
        SuperscriptBox["f", "\[Prime]",
          MultilineFunction->None], "[", \(g[3\ x]\^2\), "]"}]}]], "Output"]
}, Closed]],

Cell[TextData[{
  "Here ",
  StyleBox["Grad[g][3x]", "Output"],
  " denotes the gradient of ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  ", evaluated at ",
  Cell[BoxData[
      \(TraditionalForm\`3\ x\)]],
  ". For the example above to make sense, we (and the computer) must think of \
",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " as a real-valued function on some Euclidean space (where ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " lives) and ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " as a function from ",
  StyleBox["R",
    FontWeight->"Bold"],
  " to ",
  StyleBox["R",
    FontWeight->"Bold"],
  ".  Let's find the Laplacian of the same function:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Laplacian[f[g[3  x]\^2], x]\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
      "18", " ", \((\[LeftDoubleBracketingBar]\(Grad[g]\)[3\ x]\
\[RightDoubleBracketingBar]\^2 + g[3\ x]\ \(Laplacian[g]\)[3\ x])\), " ", 
        RowBox[{
          SuperscriptBox["f", "\[Prime]",
            MultilineFunction->None], "[", \(g[3\ x]\^2\), "]"}]}], "+", 
      RowBox[{
      "36", " ", \(g[3\ x]\^2\), 
        " ", \(\[LeftDoubleBracketingBar]\(Grad[g]\)[
                3\ x]\[RightDoubleBracketingBar]\^2\), " ", 
        RowBox[{
          SuperscriptBox["f", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", \(g[3\ x]\^2\), 
          "]"}]}]}]], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Laplacian[g][3x]", "InlineInput"],
  " denotes, of course, the Laplacian of ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  ", evaluated at ",
  Cell[BoxData[
      \(TraditionalForm\`3\ x\)]],
  "."
}], "Text"],

Cell[TextData[{
  "All our differentiation commands (",
  StyleBox["Partial", "InlineInput"],
  ", ",
  StyleBox["Laplacian", "InlineInput"],
  ", ",
  StyleBox["Gradient", "InlineInput"],
  ", ",
  StyleBox["NormalD", "InlineInput"],
  ", ",
  StyleBox["Divergence", "InlineInput"],
  ", ",
  StyleBox["Jacobian", "InlineInput"],
  ") and ",
  StyleBox["Homogeneous", "InlineInput"],
  " and ",
  StyleBox["Taylor", "InlineInput"],
  " can be used with non-explicit functions.  For example, if working in ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontWeight->"Bold",
            FontSlant->"Plain"], "2"], TraditionalForm]]],
  ", to find the term of degree 3 in the homogeneous expansion of ",
  Cell[BoxData[
      \(TraditionalForm\`f(\((g(3  x))\)\^2)\)]],
  " about the origin, you would enter the command ",
  StyleBox["SetDimension[x, 2]", "InlineInput"],
  " and then the command ",
  StyleBox["Homogeneous[", "InlineInput"],
  StyleBox[Cell[BoxData[
      \(f[g[3  x]\^2]\)], "InlineInput"], "InlineInput"],
  StyleBox[", 3, x].", "InlineInput"],
  " Try it! In the answer you will see terms such as ",
  Cell[BoxData[
      StyleBox[\(\(Partial\_{1, 1, 2}[g]\)[0]\),
        "Output"]]],
  ", which denotes the partial derivative of ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  ", twice with respect to the first variable and once with respect to the \
second variable, evaluated at 0."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Vector-valued functions", "Subsection",
  CellTags->"Vector-valued Functions"],

Cell[TextData[{
  "Suppose we compute the partial derivative with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  " of the function that takes ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`f \((g \((\(h(x)\)\^2)\))\)\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partial[f[g[h[x]\^2]], x\_1]\)], "Input"],

Cell[BoxData[
    RowBox[{"2", " ", \(h[x]\), " ", 
      RowBox[{
        SuperscriptBox["f", "\[Prime]",
          MultilineFunction->None], "[", \(g[h[x]\^2]\), "]"}], " ", 
      RowBox[{
        SuperscriptBox["g", "\[Prime]",
          MultilineFunction->None], "[", \(h[x]\^2\), "]"}], 
      " ", \(\(Partial\_{1}[h]\)[x]\)}]], "Output"]
}, Closed]],

Cell[TextData[{
  "The example above illustrates a general principle: This package assumes \
that all functions are real valued, unless told otherwise.  Thus the last \
output is correct if we are thinking of ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " as a real-valued function. If we want to think of ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " as taking values in ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontWeight->"Bold",
            FontSlant->"Plain"], "n"], TraditionalForm]]],
  ", we must first enter the \ncommand ",
  StyleBox["SetDimension[g[_], n]", "InlineInput"],
  ", which instructs the computer that ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " is a function with range in ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontWeight->"Bold",
            FontSlant->"Plain"], "n"], TraditionalForm]]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    StyleBox[\(SetDimension[g[_], \ n]\),
      "InlineInput"]], "Input"],

Cell[BoxData[
    \(SetDimension::"VectorValuedFunction" \(\(:\)\(\ \)\) 
      "\!\(g\) will be considered to be a function taking values in \
\!\(n\)-dimensional Euclidean space."\)], "Message"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partial[f[g[h[x]\^2]], x\_1]\)], "Input"],

Cell[BoxData[
    RowBox[{"2", " ", 
      RowBox[{\(\(Grad[f]\)[g[h[x]\^2]]\), ".", 
        RowBox[{
          SuperscriptBox["g", "\[Prime]",
            MultilineFunction->None], "[", \(h[x]\^2\), "]"}]}], 
      " ", \(h[x]\), " ", \(\(Partial\_{1}[h]\)[x]\)}]], "Output"]
}, Closed]],

Cell[TextData[{
  "Note that the last output  involves the dot product of two vectors: the \
gradient of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  ", evaluated at ",
  Cell[BoxData[
      \(TraditionalForm\`g \((\(h(x)\)\^2)\)\)]],
  ", and the derivative of \n",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  ", evaluated at ",
  Cell[BoxData[
      \(TraditionalForm\`\(h(x)\)\^2\)]],
  ". The last two outputs should be compared."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Volume", "Subsection",
  CellTags->"Volume"],

Cell[TextData[{
  StyleBox["Volume[n]", "InlineInput"],
  " is the volume (unnormalized) of the unit ball in ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["n",
            FontSize->10]], TraditionalForm]]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Volume[4]\)], "Input"],

Cell[BoxData[
    \(\[Pi]\^2\/2\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Volume", "InlineInput"],
  " is computed using the formula given by Exercise 6 in Appendix A of [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["SurfaceArea", "Subsection",
  CellTags->"SurfaceArea"],

Cell[TextData[{
  StyleBox["SurfaceArea[n]", "InlineInput"],
  " is the surface area (unnormalized) of the unit sphere in ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["n",
            FontSize->10]], TraditionalForm]]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SurfaceArea[57]\)], "Input"],

Cell[BoxData[
    \(\(536870912\ \[Pi]\^28\)\/8687364368561751199826958100282265625\)], \
"Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["SurfaceArea[n]", "InlineInput"],
  " is computed by multiplying the formula for ",
  StyleBox["Volume[n]", "InlineInput"],
  " by ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "; see A.2 in Appendix A of [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["IntegrateSphere", "Subsection",
  CellTags->"IntegrateSphere"],

Cell[TextData[{
  StyleBox["IntegrateSphere[f, x]", "InlineInput"],
  " equals the integral of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  ", with respect to normalized surface area measure, over the unit sphere in \
the Euclidean space defined by ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". Here ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " should be a polynomial function of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDimension[x, n]\)], "Input"],

Cell[BoxData[
    \(SetDimension::"Vector" \(\(:\)\(\ \)\) 
      "\!\(x\) will be considered to be a vector in \!\(n\)-dimensional real \
Euclidean space."\)], "Message"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(IntegrateSphere[x\_1\^2\ x\_2\^4\ x\_3\^6, x]\)], "Input"],

Cell[BoxData[
    \(45\/\(n\ \((2 + n)\)\ \((4 + n)\)\ \((6 + n)\)\ \((8 + n)\)\ \((10 + n)\
\)\)\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["IntegrateSphere", "InlineInput"],
  " is computed by using the results in Section 3 of [",
  ButtonBox["W",
    ButtonData:>"W",
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["IntegrateBall", "Subsection",
  CellTags->"IntegrateBall"],

Cell[TextData[{
  StyleBox["IntegrateBall[f, x]", "InlineInput"],
  " equals the integral of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  ", with respect to (unnormalized) volume measure, over the unit ball in the \
Euclidean space defined by ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". Here ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " should be a function of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ||",
  Cell[BoxData[
      \(TraditionalForm\`\(\(x\)\(||\)\)\)]],
  " that is a polynomial in ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and a function in ||",
  Cell[BoxData[
      \(TraditionalForm\`\(\(x\)\(||\)\)\)]],
  " for which ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can find an explicit antiderivative:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDimension[x, 7]\)], "Input"],

Cell[BoxData[
    \(SetDimension::"Vector" \(\(:\)\(\ \)\) 
      "\!\(x\) will be considered to be a vector in \!\(7\)-dimensional real \
Euclidean space."\)], "Message"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(IntegrateBall[
      x\_1\^2\ x\_2\^4/\((1 + \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar])\), x]\)], "Input"],

Cell[BoxData[
    \(\(16\ \[Pi]\^3\ \((\(-\(18107\/27720\)\) + Log[2])\)\)\/3465\)], \
"Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["IntegrateBall", "InlineInput"],
  " is computed by converting to polar coordinates and then using the \
function ",
  StyleBox["IntegrateSphere ", "InlineInput"],
  "(see [",
  ButtonBox["R",
    ButtonData:>"R",
    ButtonStyle->"Hyperlink"],
  "], Chapter 8, Exercise 6)."
}], "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Boundary Value Problems", "Section",
  CellTags->"Boundary Value Problems"],

Cell[CellGroupData[{

Cell["Dirichlet problems", "Subsection",
  CellTags->"Dirichlet"],

Cell[CellGroupData[{

Cell["The Dirichlet problem on the sphere", "Subsubsection"],

Cell[TextData[{
  StyleBox["Dirichlet[p, x]", "InlineInput"],
  " is the solution to the standard Dirichlet problem: find the harmonic \
function on the unit ball in the Euclidean space defined by ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " that equals ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " on the unit sphere.  Thus ",
  StyleBox["Dirichlet[p, x]", "InlineInput"],
  " is the Poisson integral of ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " as a function of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ".  Here ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " must be a polynomial function of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDimension[x, 5]\)], "Input"],

Cell[BoxData[
    \(SetDimension::"Vector" \(\(:\)\(\ \)\) 
      "\!\(x\) will be considered to be a vector in \!\(5\)-dimensional real \
Euclidean space."\)], "Message"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dirichlet[x\_1\^4\ x\_2\^2, x]\)], "Input"],

Cell[BoxData[
    \(\(\(1\/15015\)\((143 - 
        273\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2 + 
        165\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^4 - 
        35\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^6 + 
        910\ x\_1\%2 - 
        1540\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ x\_1\
\%2 + 630\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^4\ x\_1\%2 \
+ 1155\ x\_1\%4 - 
        1155\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ x\_1\
\%4 + 455\ x\_2\%2 - 
        770\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ \
x\_2\%2 + 
        315\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^4\ \
x\_2\%2 + 6930\ x\_1\%2\ x\_2\%2 - 
        6930\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ x\_1\
\%2\ x\_2\%2 + 15015\ x\_1\%4\ x\_2\%2)\)\)\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The last output is a harmonic function on ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontWeight->"Bold",
            FontSlant->"Plain"], "5"], TraditionalForm]]],
  "that equals ",
  Cell[BoxData[
      \(TraditionalForm\`\(x\_1\^4\) x\_2\^2\)]],
  " on the unit sphere. To check this, first we take the Laplacian of the \
last output, and then we evaluate the last output on the unit sphere:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Laplacian[%, \ x]\)], "Input"],

Cell[BoxData[
    \(0\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(%%\  /. \ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar] \
\[Rule] 1\)], "Input"],

Cell[BoxData[
    \(x\_1\%4\ x\_2\%2\)], "Output"]
}, Closed]],

Cell["Thus we have indeed solved the specified Dirichlet problem.", "Text"],

Cell[TextData[{
  "The solution to the Dirichlet problem on the sphere is computed by using \
the algorithm described in [",
  ButtonBox["AR",
    ButtonData:>"AR",
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["The Dirichlet problem on the exterior of the sphere", "Subsubsection"],

Cell[TextData[{
  "The ",
  StyleBox["Region", "InlineInput"],
  " option allows the user to solve Dirichlet problems on regions other than \
the sphere. Currently supported values for ",
  StyleBox["Region", "InlineInput"],
  " are ",
  StyleBox["Sphere", "InlineInput"],
  ", ",
  StyleBox["ExteriorSphere", "InlineInput"],
  ", ",
  StyleBox["Annulus", "InlineInput"],
  ", and ",
  StyleBox["Quadratic", "InlineInput"],
  ". The default value of ",
  StyleBox["Region", "InlineInput"],
  " is ",
  StyleBox["Sphere", "InlineInput"],
  "; thus ",
  StyleBox["Dirichlet[p, x, Region\[Rule]Sphere]", "InlineInput"],
  " is the same as ",
  StyleBox["Dirichlet[p, x]", "InlineInput"],
  "."
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      \(Dirichlet[p, x, \ Region \[Rule] ExteriorSphere]\)], "InlineInput"],
  " gives the solution to the standard exterior Dirichlet problem: find the \
harmonic function on the exterior (including \[Infinity]) of the unit ball in \
the Euclidean space defined by ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " that equals ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " on the unit sphere. This function is the exterior Poisson integral of ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " as a function of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " (see Theorem 4.11 of [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "]).  Here ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " must be a polynomial function of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dirichlet[x\_1\^4\ x\_2\^2, x, \ 
      Region \[Rule] ExteriorSphere]\)], "Input"],

Cell[BoxData[
    \(\(\(1\/\(15015\ \
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^15\)\)\((\(-35\)\ \
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^6 + 
        165\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^8 - 
        273\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^10 + 
        143\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^12 + 
        630\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^4\ \
x\_1\%2 - 
        1540\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^6\ x\_1\
\%2 + 910\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^8\ x\_1\%2 \
- 1155\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ x\_1\%4 + 
        1155\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^4\ x\_1\
\%4 + 315\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^4\ x\_2\%2 \
- 770\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^6\ x\_2\%2 + 
        455\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^8\ \
x\_2\%2 - 
        6930\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ x\_1\
\%2\ x\_2\%2 + 
        6930\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^4\ x\_1\
\%2\ x\_2\%2 + 15015\ x\_1\%4\ x\_2\%2)\)\)\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The last output is a harmonic function on the exterior of the unit ball in \
",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontWeight->"Bold",
            FontSlant->"Plain"], "5"], TraditionalForm]]],
  " (because the dimension of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " was set to 5 earlier) that equals ",
  Cell[BoxData[
      \(TraditionalForm\`\(x\_1\^4\) x\_2\^2\)]],
  " on the unit sphere. This function is the Kelvin transform of the solution \
that would have been obtained without the ",
  StyleBox["Region\[Rule]Sphere", "InlineInput"],
  " option; see Chapter 4 of [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["The Dirichlet problem on annular regions", "Subsubsection"],

Cell[TextData[{
  Cell[BoxData[
      \(Dirichlet[{p, q}, x, \ Region \[Rule] Annulus[r, s]\ ]\)], 
    "InlineInput"],
  " gives the solution to the annular Dirichlet problem: find the harmonic \
function on the annular region with inner radius ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " and outer radius ",
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  " that equals ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " on the sphere of radius ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " and equals ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " on the sphere of radius ",
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  ". Here ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " must be polynomial functions of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dirichlet[{x\_1\^3, x\_3\^2}, x, \ 
      Region \[Rule] Annulus[1, 4]]\)], "Input"],

Cell[BoxData[
    \(\(-\(1024\/315\)\)\ \((\(-1\) + 
            1\/\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^3)\) + \
\(1024\ \((\(-\(1\/1024\)\) + 1\/\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^5)\)\ x\_1\)\/2387 + \(\((\(-262144\) + \
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^9)\)\ \((3\ \
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ x\_1 - 7\ x\_1\%3)\
\)\)\/\(1835001\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^9\) \
- \(16384\ \((\(-1\) + 1\/\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^7)\)\ \((\(-\(\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2\/5\)\) + x\_3\%2)\)\)\/16383\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Now we check that the last output is harmonic on ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontWeight->"Bold",
            FontSlant->"Plain"], "5"], TraditionalForm]]],
  " (because the dimension of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " was set to 5 earlier), that it equals ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\^3\)]],
  " on the sphere of radius 1, and that it equals ",
  Cell[BoxData[
      \(TraditionalForm\`x\_3\^2\)]],
  " on the sphere of radius 4:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Laplacian[%, \ x]\)], "Input"],

Cell[BoxData[
    \(0\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(%%\  /. \ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar] \
\[Rule] 1\)], "Input"],

Cell[BoxData[
    \(x\_1\%3\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(%%%\  /. \ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar] \
\[Rule] 4\)], "Input"],

Cell[BoxData[
    \(x\_3\%2\)], "Output"]
}, Closed]],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      \(TraditionalForm\`p = q\)]],
  ", then the shortcut ",
  Cell[BoxData[
      \(Dirichlet[p, x, \ Region \[Rule] Annulus[r, s]\ ]\)], "InlineInput"],
  " can be used instead of ",
  Cell[BoxData[
      \(Dirichlet[{p, q}, x, \ Region \[Rule] Annulus[r, s]\ ]\)], 
    "InlineInput"],
  "."
}], "Text"],

Cell[TextData[{
  "The solution to the Dirichlet problem on an annulus is computed by using \
the techniques described in Chapter 10 of [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["The Dirichlet problem on quadratic surfaces", "Subsubsection"],

Cell[TextData[{
  Cell[BoxData[
      \(Dirichlet[p, x, \ Region \[Rule] Quadratic[b, \ c, d]\ ]\)], 
    "InlineInput"],
  " gives the harmonic polynomial that equals ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " on the quadratic surface"
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`b . x\^2 + \ c . x\  + \ d\  = \ 0\)]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Here ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  " must be lists whose length equals the dimension of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " must be a polynomial function of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". For example, here we find the harmonic polynomial that equals ",
  Cell[BoxData[
      \(TraditionalForm\`\(x\_1\^3\) x\_3\^2\)]],
  "on the elliptic paraboloid given by the equation"
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`2  x\_1\^2 + 3  x\_2\^2\  = \ 
      4  x\_3 + \ 1\)]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "in ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontWeight->"Bold",
            FontSlant->"Plain"], "3"], TraditionalForm]]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDimension[x, 3]\)], "Input"],

Cell[BoxData[
    \(SetDimension::"Vector" \(\(:\)\(\ \)\) 
      "\!\(x\) will be considered to be a vector in \!\(3\)-dimensional real \
Euclidean space."\)], "Message"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dirichlet[\(x\_1\^3\) x\_3\^2, x, 
      Region \[Rule] Quadratic[{2, 3, 0}, {0, 0, \(-4\)}, \(-1\)]]\)], "Input"],

Cell[BoxData[
    \(x\_1\%3\ x\_3\%2 + \(\((\(-1\) + 2\ x\_1\%2 + 3\ x\_2\%2 - 4\ x\_3)\)\ \
\((\(-5123\)\ x\_1 - 405\ x\_1\%3 + 1053\ x\_1\ x\_2\%2 - 9684\ x\_1\ x\_3 - \
7209\ x\_1\ x\_3\%2)\)\)\/21627\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The last output is of the form ",
  Cell[BoxData[
      \(TraditionalForm\`\(x\_1\^3\) 
          x\_3\^2 + \((2  x\_1\^2 + 3  x\_2\^2 - 4  x\_3 - 1)\) f\)]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " is a polynomial. Thus the last output obviously equals ",
  Cell[BoxData[
      \(TraditionalForm\`\(x\_1\^3\) x\_3\^2\)]],
  " on the elliptic parabolic given by the equation ",
  Cell[BoxData[
      \(TraditionalForm\`2  x\_1\^2 + 3  x\_2\^2\  = \ 4  x\_3 + \ 1\)]],
  ". Thus to verify that the last output is correct, we only need check that \
it is harmonic:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Laplacian[%, \ x]\)], "Input"],

Cell[BoxData[
    \(0\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The solution to the Dirichlet problem on a quadratic surface is computed \
by using the algorithm developed in [",
  ButtonBox["AGV",
    ButtonData:>"AGV",
    ButtonStyle->"Hyperlink"],
  "]. That paper also shows that if each coordinate of ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  " is nonnegative and at least one coordinate of ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  " is nonzero, and if the quadratic surface in question is nontrivial in the \
sense that there exits ",
  Cell[BoxData[
      FormBox[
        RowBox[{"x", " ", "\[Epsilon]", " ", 
          SuperscriptBox[
            StyleBox["R",
              FontWeight->"Bold"], "n"]}], TraditionalForm]]],
  " such that"
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`b . x\^2 + \ c . x\  + \ d\  < \ 0\)]],
  ","
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "then the polynomial produced by this algorithm is the unique harmonic \
polynomial that equals ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " on the quadratic surface in question."
}], "Text"],

Cell[TextData[{
  "Using the notation above, if ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  " consists of all 0's, then it may be omitted. For example, here we find \
the harmonic polynomial that equals ",
  Cell[BoxData[
      \(TraditionalForm\`\(x\_1\^4\) x\_3\^2\)]],
  "on the ellipsoid given by the equation ",
  Cell[BoxData[
      \(TraditionalForm\`2  x\_1\^2 + 3  x\_2\^2 + 4  x\_3\^2 = 1\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dirichlet[\(x\_1\^4\) x\_3\^2, x, 
      Region \[Rule] Quadratic[{2, 3, 4}, \(-1\)]]\)], "Input"],

Cell[BoxData[
    \(x\_1\%4\ x\_3\%2 + \(\(1\/39309793479\)\((\((\(-1\) + 2\ x\_1\%2 + 
              3\ x\_2\%2 + 4\ x\_3\%2)\)\ \((\(-52529359\) - 
              511000770\ x\_1\%2 - 801788415\ x\_1\%4 + 102950118\ x\_2\%2 + 
              945182934\ x\_1\%2\ x\_2\%2 - 67605435\ x\_2\%4 - 
              64713579\ x\_3\%2 - 5766993996\ x\_1\%2\ x\_3\%2 + 
              204109461\ x\_2\%2\ x\_3\%2 + 
              342331356\ x\_3\%4)\))\)\)\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Generalized Dirichlet problems", "Subsubsection"],

Cell[TextData[{
  "The generalized Dirichlet problem asks for a function with specified \
boundary values on some surface and with specified Laplacian inside that \
surface. Thus if the Laplacian is required to be 0, then this is the same as \
the usual Dirichlet problem. The generalized Dirichlet problem with specified \
Laplacian equal to ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " is solved by adding the option ",
  Cell[BoxData[
      StyleBox[\(Laplacian \[Rule] \ p\),
        "InlineInput"]]],
  " to the ",
  StyleBox["Dirichlet", "InlineInput"],
  " function; here ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " must be a polynomial. For example, we can find the function that equals \
",
  Cell[BoxData[
      \(TraditionalForm\`\(x\_1\^3\) x\_2\^2\)]],
  "on the unit sphere in ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontWeight->"Bold",
            FontSlant->"Plain"], "3"], TraditionalForm]]],
  " and whose Laplacian equals ",
  Cell[BoxData[
      \(TraditionalForm\`\(x\_2\^2\) x\_3\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dirichlet[\(x\_1\^3\) x\_2\^2, \ x, \ 
      Laplacian \[Rule] \ \(x\_2\^2\) x\_3]\)], "Input"],

Cell[BoxData[
    \(\(\(1\/1260\)\((108\ x\_1 - 
        168\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ x\_1 \
+ 60\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^4\ x\_1 + 
        140\ x\_1\%3 - 
        140\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ \
x\_1\%3 + 420\ x\_1\ x\_2\%2 - 
        420\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ x\_1\ \
x\_2\%2 + 1260\ x\_1\%3\ x\_2\%2 - 9\ x\_3 + 
        14\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ x\_3 - 
        5\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^4\ x\_3 - 
        70\ x\_2\%2\ x\_3 + 
        70\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ \
x\_2\%2\ x\_3)\)\)\)], "Output"]
}, Closed]],

Cell[TextData[{
  "We can check that output above correctly solves the generalized Dirichlet \
problem by verifying that the Laplacian of the last output indeed equals ",
  Cell[BoxData[
      \(TraditionalForm\`\(x\_2\^2\) x\_3\)]],
  " and that the last output restricted to the unit sphere indeed equals ",
  Cell[BoxData[
      \(TraditionalForm\`\(x\_1\^3\) x\_2\^2\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Laplacian[%, \ x]\)], "Input"],

Cell[BoxData[
    \(x\_2\%2\ x\_3\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(%%\  /. \ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar] \
\[Rule] 1\)], "Input"],

Cell[BoxData[
    \(x\_1\%3\ x\_2\%2\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The ",
  StyleBox["Laplacian", "InlineInput"],
  " option can be used combined with the ",
  StyleBox["Region", "InlineInput"],
  " option to solve the generalized Dirichlet problem on any region for which \
this package can solve the usual Dirichlet problem. The order of the options \
does not matter. Here we find the function on ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontWeight->"Bold",
            FontSlant->"Plain"], "3"], TraditionalForm]]],
  " whose Laplacian equals ",
  Cell[BoxData[
      \(TraditionalForm\`x\_2\^2\)]],
  "and that equals ",
  Cell[BoxData[
      \(TraditionalForm\`\(x\_1\^4\) x\_3\^2\)]],
  "on the ellipsoid ",
  Cell[BoxData[
      \(TraditionalForm\`2  x\_1\^2 + 3  x\_2\^2 + 4  x\_3\^2 - \ 1\  = \ 
        0\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dirichlet[\(x\_1\^4\) x\_3\^2, x, Laplacian \[Rule] x\_2\^2, 
      Region \[Rule] Quadratic[{2, 3, 4}, \(-1\)]]\)], "Input"],

Cell[BoxData[
    \(x\_1\%4\ x\_3\%2 + \(\(1\/157239173916\)\((\((\(-1\) + 2\ x\_1\%2 + 
              3\ x\_2\%2 + 4\ x\_3\%2)\)\ \((82719889 - 2354066130\ x\_1\%2 - 
              3207153660\ x\_1\%4 + 3779085195\ x\_2\%2 + 
              3780731736\ x\_1\%2\ x\_2\%2 - 270421740\ x\_2\%4 - 
              680540064\ x\_3\%2 - 23067975984\ x\_1\%2\ x\_3\%2 + 
              816437844\ x\_2\%2\ x\_3\%2 + 
              1369325424\ x\_3\%4)\))\)\)\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The form of the last output shows, without calculutation, that it \
obviously equals ",
  Cell[BoxData[
      \(TraditionalForm\`\(x\_1\^4\) x\_3\^2\)]],
  "on the ellipsoid ",
  Cell[BoxData[
      \(TraditionalForm\`2  x\_1\^2 + 3  x\_2\^2 + 4  x\_3\^2 - \ 1\  = \ 
        0\)]],
  ". Thus to verify that we have correctly solved this generalized Dirichlet \
problem, we only need to check that the Laplacian equals ",
  Cell[BoxData[
      \(TraditionalForm\`x\_2\^2\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Laplacian[%, \ x]\)], "Input"],

Cell[BoxData[
    \(x\_2\%2\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Dirichlet problems with explicit coordinates", "Subsubsection"],

Cell[TextData[{
  "So far we have worked with symbolic vectors, which we have usually called  \
",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " or ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  ". Vectors can also be described by giving explicit coordinates in the form \
of a list. Both formats (symbolic vectors and explicit lists) work with all \
functions in this package. For example, suppose we are working in ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontWeight->"Bold",
            FontSlant->"Plain"], "3"], TraditionalForm]]],
  " and want to use ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  " instead of ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`x\_2\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`x\_3\)]],
  ". Here is how to find the Poisson integral of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(\(x\^3\) y\),
            "TraditionalForm"], \(z\^2\)}], TraditionalForm]]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dirichlet[\(x\^3\) y\ z\^2, \ {x, y, z}]\)], "Input"],

Cell[BoxData[
    \(1\/231\ \((11\ x\ y + 3\ x\^3\ y - 14\ x\^5\ y - 18\ x\ y\^3 - 
          7\ x\^3\ y\^3 + 7\ x\ y\^5 + 45\ x\ y\ z\^2 + 161\ x\^3\ y\ z\^2 - 
          49\ x\ y\^3\ z\^2 - 56\ x\ y\ z\^4)\)\)], "Output"]
}, Closed]],

Cell["\<\
To check that the last output is correct, first we verify that is \
harmonic by checking that its Laplacian equals 0:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Laplacian[%, \ {x, y, z}]\)], "Input"],

Cell[BoxData[
    \(0\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Now we check that the difference between the claimed solution to the \
Dirichlet problem equals ",
  Cell[BoxData[
      \(TraditionalForm\`\(x\^3\) yz\^2\)]],
  " on the unit sphere by verifying that the difference between these two \
functions, when restricted to the unit sphere, equals 0:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(x\^3\) y\ z\^2 - \ %%\  /. \ 
      z \[Rule] \@\(1 - x\^2 - y\^2\)\)], "Input"],

Cell[BoxData[
    \(0\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Here is another example using explicit coordinates. In this example, we \
find the function on ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontWeight->"Bold",
            FontSlant->"Plain"], "3"], TraditionalForm]]],
  " whose Laplacian equals ",
  Cell[BoxData[
      \(TraditionalForm\`\(y\^2\) z\)]],
  " and that equals ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(\(x\^3\) y\),
            "TraditionalForm"], \(z\^2\)}], TraditionalForm]]],
  " on the ellipsoind ",
  Cell[BoxData[
      \(TraditionalForm\`2  x\^2 + 3  y\^2 + 4  z\^2 - \ 1\  = \ 0\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dirichlet[\(x\^3\) y\ z\^2, \ {x, y, z}, \ 
      Region \[Rule] Quadratic[{2, 3, 4}, \(-1\)], \ 
      Laplacian \[Rule] \(y\^2\) z\^3]\)], "Input"],

Cell[BoxData[
    \(x\^3\ y\ z\^2 + \((\(-1\) + 2\ x\^2 + 3\ y\^2 + 
            4\ z\^2)\)\ \((\(-\(\(961\ x\ y\)\/150917\)\) - \(223\ x\^3\ \
y\)\/7943 + \(93\ x\ y\^3\)\/7943 + \(6128862523\ z\)\/154091469268302 - \
\(424717558\ x\^2\ z\)\/4532102037303 + \(44102\ x\^4\ z\)\/734657487 + \
\(3416529117\ y\^2\ z\)\/6042802716404 - \(448445\ x\^2\ y\^2\ z\)\/489771658 \
- \(1320573\ y\^4\ z\)\/979543316 - \(571\ x\ y\ z\^2\)\/7943 + \(1235669309\ \
z\^3\)\/18128408149212 - \(213085\ x\^2\ z\^3\)\/1469314974 + \(8956053\ y\^2\
\ z\^3\)\/979543316 - \(297101\ z\^5\)\/734657487)\)\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Obviously the last output equals ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(\(x\^3\) y\),
            "TraditionalForm"], \(z\^2\)}], TraditionalForm]]],
  " on the ellipsoind ",
  Cell[BoxData[
      \(TraditionalForm\`2  x\^2 + 3  y\^2 + 4  z\^2 - \ 1\  = \ 0\)]],
  ". We now check that its Laplacian is the desired function:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Laplacian[%, \ {x, y, z}]\)], "Input"],

Cell[BoxData[
    \(y\^2\ z\^3\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["HarmonicDecomposition", "Subsection",
  CellTags->"HarmonicDecomposition"],

Cell[TextData[{
  StyleBox["HarmonicDecomposition[p, x]", "InlineInput"],
  " gives the decomposition of ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " into a sum of harmonic polynomials (on the Euclidean space defined by ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ") times powers of ||",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "||.  Here ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " must be a polynomial function of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDimension[x, n]\)], "Input"],

Cell[BoxData[
    \(SetDimension::"Vector" \(\(:\)\(\ \)\) 
      "\!\(x\) will be considered to be a vector in \!\(n\)-dimensional real \
Euclidean space."\)], "Message"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(HarmonicDecomposition[x\_1\^4, x]\)], "Input"],

Cell[BoxData[
    \({{\(3\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^4\)\/\(8 \
+ 6\ n + n\^2\) - \(6\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\
\^2\ x\_1\%2\)\/\(4 + n\) + x\_1\%4, 
        0}, {\(6\ \
\((\(-\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\) + n\ \
x\_1\%2)\)\)\/\(n\ \((4 + n)\)\), 2}, {3\/\(n\ \((2 + n)\)\), 4}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The output given by ",
  StyleBox["HarmonicDecomposition[p, x]", "InlineInput"],
  " consists of a list of pairs. The first entry in each pair is a harmonic \
function, the second entry is the power of ||",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "|| by which the first entry should be multiplied so that the sum of the \
resulting terms equals ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  ". For example, in the last output ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[
            FractionBox[
              RowBox[{"3", "||", 
                FormBox["x",
                  
                  "TraditionalForm"], \( || \^4\)}], \(\((2 + n)\) \((4 + 
                    n)\)\)],
            FontSize->16], "-", 
          StyleBox[
            FractionBox[
              RowBox[{"6", "||", 
                FormBox["x",
                  "TraditionalForm"], \( || \^2\), \(x\_1\^2\)}], \(4 + n\)],
            FontSize->16], "+", \(x\_1\^4\)}], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          FractionBox[
            RowBox[{"6", 
              RowBox[{"(", 
                RowBox[{"-", 
                  RowBox[{"||", 
                    FormBox["x",
                      
                      "TraditionalForm"], \( || \^2\), \(\(+\ 
                        n\)\ x\_1\^2\)}]}], ")"}]}], \(n(4 + n)\)],
          FontSize->16], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(3\/\(n(2 + n)\)\),
          FontSize->16], TraditionalForm]]],
  " are harmonic functions of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "; furthermore"
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\(\(x\_1\^4\)\(\ \)\(=\)\(\ \)\)\)]],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[
            FractionBox[
              RowBox[{"3", "||", 
                FormBox["x",
                  
                  "TraditionalForm"], \( || \^4\)}], \(\((2 + n)\) \((4 + 
                    n)\)\)],
            FontSize->16], "-", 
          StyleBox[
            FractionBox[
              RowBox[{"6", "||", 
                FormBox["x",
                  "TraditionalForm"], \( || \^2\), \(x\_1\^2\)}], \(4 + n\)],
            FontSize->16], "+", \(x\_1\^4\)}], TraditionalForm]]],
  " + ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            StyleBox[
              FractionBox[
                RowBox[{"6", 
                  RowBox[{"(", 
                    RowBox[{"-", 
                      RowBox[{"||", 
                        FormBox["x",
                          
                          "TraditionalForm"], \( || \^2\), \(\(+\ 
                            n\)\ x\_1\^2\)}]}], ")"}]}], \(n(4 + n)\)],
              FontSize->16],
            "TraditionalForm"], "||", "x", \( || \^2\)}], TraditionalForm]]],
  " + ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[
            FormBox[
              StyleBox[\(3\/\(n(2 + n)\)\),
                FontSize->16],
              "TraditionalForm"],
            FontSize->14], "||", "x", \( || \^4\)}], TraditionalForm]]],
  "."
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "For a proof of the existence and uniqueness of the harmonic decomposition, \
see [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "], Theorem 5.7. ",
  StyleBox["HarmonicDecomposition", "InlineInput"],
  " is computed using the algorithm described in Section 2 of [",
  ButtonBox["AR",
    ButtonData:>"AR",
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["AntiLaplacian", "Subsection",
  CellTags->"AntiLaplacian"],

Cell[TextData[{
  StyleBox["AntiLaplacian[u, x]", "InlineInput"],
  " gives an anti-Laplacian of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "; this is a function whose Laplacian with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " equals ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ".  Here ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " must  be a polynomial function of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " or a sum of terms, each of which is a polynomial in ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " times a function of ||",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "||:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDimension[x, 6]\)], "Input"],

Cell[BoxData[
    \(SetDimension::"Vector" \(\(:\)\(\ \)\) 
      "\!\(x\) will be considered to be a vector in \!\(6\)-dimensional real \
Euclidean space."\)], "Message"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(AntiLaplacian[
      x\_1\^2\ x\_2\ \
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^3\ Log[\
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]], x]\)\(\n\)
    \)\)], "Input"],

Cell[BoxData[
    \(\(\((\(-20\)\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^7 \
+ 91\ Log[\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]]\ \
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^7)\)\ x\_2\)\/66248 - \
\(\((\(-4\)\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^5 + 15\ \
Log[\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]]\ \
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^5)\)\ \((\
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ x\_2 - 8\ x\_1\%2\ \
x\_2)\)\)\/9000\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The function given by the last output has Laplacian equal to ",
  Cell[BoxData[
      \(TraditionalForm\`\(x\_1\^2\) \(x\_2\) \(\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^3\) \(log(\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar])\)\)]],
  "on ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontWeight->"Bold",
            FontSlant->"Plain"], "6"], TraditionalForm]]],
  ", as we can easily verify:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Laplacian[%, \ x]\)], "Input"],

Cell[BoxData[
    \(Log[\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]]\ \
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^3\ x\_1\%2\ x\_2\)], \
"Output"]
}, Closed]],

Cell[TextData[{
  "To understand how ",
  StyleBox["AntiLaplacian", "InlineInput"],
  " is computed, suppose we want to find an anti-Laplacian of ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  "(",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ")",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  "(||",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "||), where ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " is a polynomial on ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontWeight->"Bold",
            FontSlant->"Plain"], "n"], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " is a continuous function on (0, \[Infinity]).  Applying ",
  StyleBox["HarmonicDecomposition", "InlineInput"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  ", using linearity, and replacing ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  "(||",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "||) with a power of ||",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "|| times ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  "(||",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "||), we see that we only need to find anti-Laplacians of functions of the \
form ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  "(",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ")",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  "(||",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "||), where ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " is a harmonic polynomial on ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontWeight->"Bold",
            FontSlant->"Plain"], "n"], TraditionalForm]]],
  " homogeneous of degree ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  ".  To find an anti-Laplacian of ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  "(",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ")",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  "(||",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "||), suppose ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  " is a twice-differentiable function on (0, \[Infinity]).  The Laplacian of \
",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  "(",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ")",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  "(||",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "||) equals"
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  "(",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ") ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[
            FractionBox[
              RowBox[{
                RowBox[{
                  RowBox[{\((2  m\  + \ n\  - \ 1)\), " ", \(h'\), 
                    RowBox[{"(", 
                      RowBox[{"||", 
                        FormBox["x",
                          "TraditionalForm"], "||"}], ")"}]}], " ", "+"}], 
                " ", "||", 
                FormBox["x",
                  "TraditionalForm"], "||", " ", 
                RowBox[{\(h''\), 
                  RowBox[{"(", 
                    RowBox[{"||", 
                      FormBox["x",
                        "TraditionalForm"], "||"}], ")"}]}]}], 
              RowBox[{"||", 
                FormBox["x",
                  "TraditionalForm"], "||"}]],
            FontSize->16], ","}], TraditionalForm]]]
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "where we have used the product rule for Laplacians (see 1.19 in [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "]) and Exercise 29, Chapter 1 of [ABR].  We want to make the expression \
above equal  ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  "(",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ")",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  "(||",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "||), so we need only solve the differential equation"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        StyleBox[\(\(\((2  m\  + \ n\  - \ 1)\)\ h' \((t)\)\  + \ 
                t\ h'' \((t)\)\)\/t\),
          FontSize->16], " ", "=", " ", \(\(f(t)\)\(.\)\)}], 
      TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell["A solution to this equation is given by", "Text"],

Cell[BoxData[
    \(TraditionalForm\`h(
        t)\  = \ \[Integral]\_a\%t s\^\(1 - 2  m - n\)\ \(\[Integral]\_b\%s\( 
                  r\^\(2  m + n - 1\)\) \(f(
                r)\) \[DifferentialD]r \[DifferentialD]s\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "for any choice of the constants ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  ". ",
  StyleBox["AntiLaplacian", "InlineInput"],
  " uses the formula above with ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  " = 0, although if a singularity is encountered at 0 it automatically makes \
a different choice. If you know there is a singularity at 0, you can save \
some time by using the option ",
  StyleBox["Singularity \[Rule] 0", "InlineInput"],
  ", as illustrated by the following example. The two timing tests below show \
a large speed-up when using the option ",
  StyleBox["Singularity \[Rule] 0", "InlineInput"],
  ":\n"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[
      AntiLaplacian[
        x\_1\^2\ x\_2\ \ \ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^10, x]]\)], "Input"],

Cell[BoxData[
    \({5.066999999999999`\ Second, \(\(1\/512000000000\)\((\((9228128553 - 
                36910191780\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]] + 
                73808771400\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^2 - 
                98372988000\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^3 + 
                98276220000\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^4 - 
                78427440000\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^5 + 
                51962400000\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^6 - 
                29232000000\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^7 + 
                14040000000\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^8 - 
                5600000000\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^9 + 
                1600000000\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^10)\)\ \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^4\ x\_2)\)\) - \
\(\(1\/573308928\)\((\((12697896925 - 
                25395793500\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]] + 
                25395791400\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^2 - 
                16930519200\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^3 + 
                8465234400\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^4 - 
                3386033280\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^5 + 
                1128556800\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^6 - 
                322237440\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^7 + 
                80248320\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^8 - 
                17418240\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^9 + 
                2985984\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^10)\)\ \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2\ \((\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2\ x\_2 - 8\ x\_1\%2\ x\_2)\))\)\)}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[
      AntiLaplacian[
        x\_1\^2\ x\_2\ \ \ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^10, x, \ Singularity \[Rule] \ 0]]\)], "Input"],

Cell[BoxData[
    \({0.12100000000000044`\ Second, \(\(1\/512000000000\)\((\((9228128553 - 
                36910191780\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]] + 
                73808771400\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^2 - 
                98372988000\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^3 + 
                98276220000\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^4 - 
                78427440000\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^5 + 
                51962400000\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^6 - 
                29232000000\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^7 + 
                14040000000\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^8 - 
                5600000000\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^9 + 
                1600000000\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^10)\)\ \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^4\ x\_2)\)\) - \
\(\(1\/573308928\)\((\((12697896925 - 
                25395793500\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]] + 
                25395791400\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^2 - 
                16930519200\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^3 + 
                8465234400\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^4 - 
                3386033280\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^5 + 
                1128556800\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^6 - 
                322237440\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^7 + 
                80248320\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^8 - 
                17418240\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^9 + 
                2985984\ Log[\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]]\^10)\)\ \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2\ \((\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2\ x\_2 - 8\ x\_1\%2\ x\_2)\))\)\)}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The anti-Laplacian of a given function is never unique.  However, each \
polynomial has a unique anti-Laplacian that is a polynomial multiple of ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2\)]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " is  the variable. The option ",
  StyleBox["Multiple \[Rule] ", "InlineInput"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(Norm\^2\),
          "InlineInput",
          FontFamily->"Courier New"], TraditionalForm]]],
  " produces the unique anti-Laplacian that is a polynomial multiple of ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(AntiLaplacian[x\_1\^2\ x\_2\^5, x, Multiple \[Rule] Norm\^2]\)], "Input"],

Cell[BoxData[
    \(\(\(-45\)\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^8\ x\
\_2 + 840\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^6\ x\_1\%2\
\ x\_2 + 560\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^6\ x\_2\
\%3 - 13440\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^4\ \
x\_1\%2\ x\_2\%3 - 1344\ \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^4\ x\_2\%5 + 48384\ \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2\ x\_1\%2\ x\_2\%5\)\/1935360\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Neumann", "Subsection",
  CellTags->"Neumann"],

Cell[TextData[{
  StyleBox["Neumann[f, x]", "InlineInput"],
  " is the solution to the standard Neumann problem: find the harmonic \
function on the unit ball in the Euclidean space defined by ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " whose outward normal derivative on the unit sphere equals ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " and whose value at the origin equals 0. Here ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " must be a polynomial function of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ".  Furthermore, the integral of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " over the unit sphere with respect to surface area measure must equal 0 \
(Green's identity shows that this condition is necessary for the existence of \
a solution to the standard Neumann problem):"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDimension[x, 4]\)], "Input"],

Cell[BoxData[
    \(SetDimension::"Vector" \(\(:\)\(\ \)\) 
      "\!\(x\) will be considered to be a vector in \!\(4\)-dimensional real \
Euclidean space."\)], "Message"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(Neumann[x\_1\^6\ x\_2, x]\)\(\n\)
    \)\)], "Input"],

Cell[BoxData[
    \(x\_2\/32 + 
      1\/48\ \((\(-\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\)\
\ x\_2 + 6\ x\_1\%2\ x\_2)\) + \(3\ \((3\ \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^4\ x\_2 - 48\ \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2\ x\_1\%2\ x\_2 + 80\ x\_1\%4\ x\_2)\)\)\/1120 \
+ 1\/784\ \((\(-\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^6\)\ \
x\_2 + 30\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^4\ x\_1\%2\
\ x\_2 - 120\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ x\_1\
\%4\ x\_2 + 112\ x\_1\%6\ x\_2)\)\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["ExteriorNeumann", "Subsection",
  CellTags->"ExteriorNeumann"],

Cell[TextData[{
  StyleBox["ExteriorNeumann[f, x]", "InlineInput"],
  " is the solution to the standard exterior Neumann problem: find the \
harmonic function on the exterior of the unit ball in theEuclidean space \
defined by ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " whose outward normal derivative on the unit sphere equals ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " and whose limit at \[Infinity] equals 0.   Here ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " must be a polynomial function of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". If the dimension of the Euclidean space equals 2, then the integral of \
",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " over the unit circle with respect to arc length measure must equal 0:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDimension[x, 5]\)], "Input"],

Cell[BoxData[
    \(SetDimension::"Vector" \(\(:\)\(\ \)\) 
      "\!\(x\) will be considered to be a vector in \!\(5\)-dimensional real \
Euclidean space."\)], "Message"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExteriorNeumann[x\_1\^6\ x\_2, x]\)], "Input"],

Cell[BoxData[
    \(\(5\ x\_2\)\/\(924\ \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^5\) - \(15\ \((\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2\ x\_2 - 7\ x\_1\%2\ x\_2)\)\)\/\(2002\ \
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^9\) + \(\
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^4\ x\_2 - 18\ \
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ x\_1\%2\ x\_2 + 33\
\ x\_1\%4\ x\_2\)\/\(264\ \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^13\) + \(\(-\(1\/143\)\)\ \
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^6\ x\_2 + 3\/13\ \
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^4\ x\_1\%2\ x\_2 - \
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ x\_1\%4\ x\_2 + \
x\_1\%6\ x\_2\)\/\(10\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\
\^17\)\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["BiDirichlet", "Subsection",
  CellTags->"BiDirichlet"],

Cell[TextData[{
  StyleBox["BiDirichlet[f, x]", "InlineInput"],
  " is the solution to the standard biDirichlet problem: find the biharmonic \
function on the unit ball in the Euclidean space defined by ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " that equals ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " on the unit sphere and whose normal derivative on the unit sphere equals \
0.   (A function is called biharmonic if the Laplacian of its Laplacian \
equals 0.) Here ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " must be a polynomial function of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDimension[x, 3]\)], "Input"],

Cell[BoxData[
    \(SetDimension::"Vector" \(\(:\)\(\ \)\) 
      "\!\(x\) will be considered to be a vector in \!\(3\)-dimensional real \
Euclidean space."\)], "Message"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(BiDirichlet[x\_1\^4\ x\_2\^3, x]\)], "Input"],

Cell[BoxData[
    \(\(\(1\/30030\)\((1287\ x\_2 - 
        4524\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ x\_2 \
+ 5922\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^4\ x\_2 - 
        3420\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^6\ x\_2 \
+ 735\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^8\ x\_2 + 
        13650\ x\_1\%2\ x\_2 - 
        40530\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ \
x\_1\%2\ x\_2 + 
        40110\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^4\ \
x\_1\%2\ x\_2 - 
        13230\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^6\ \
x\_1\%2\ x\_2 + 24255\ x\_1\%4\ x\_2 - 
        48510\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ \
x\_1\%4\ x\_2 + 
        24255\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^4\ \
x\_1\%4\ x\_2 + 2275\ x\_2\%3 - 
        6755\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ x\_2\
\%3 + 6685\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^4\ \
x\_2\%3 - 
        2205\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^6\ x\_2\
\%3 + 48510\ x\_1\%2\ x\_2\%3 - 
        97020\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ \
x\_1\%2\ x\_2\%3 + 
        48510\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^4\ \
x\_1\%2\ x\_2\%3 + 135135\ x\_1\%4\ x\_2\%3 - 
        105105\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ \
x\_1\%4\ x\_2\%3)\)\)\)], "Output"]
}, Closed]],

Cell["\<\
To check that the last output is correct, first we take its \
Laplacian squared to check that we have a biharmonic function:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Laplacian\^2\)[%, \ x]\)], "Input"],

Cell[BoxData[
    \(0\)], "Output"]
}, Closed]],

Cell["\<\
Next we check that the outward normal derivative on the unit sphere \
indeed equals 0:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NormalD[%%, \ x]\)], "Input"],

Cell[BoxData[
    \(0\)], "Output"]
}, Closed]],

Cell["Finally, we check that we have the correct boundary values:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(%%%\  /. \ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar] \
\[Rule] 1\)], "Input"],

Cell[BoxData[
    \(x\_1\%4\ x\_2\%3\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Spherical Harmonics", "Section",
  CellTags->"Spherical Harmonics"],

Cell[CellGroupData[{

Cell["BasisH", "Subsection",
  CellTags->"BasisH"],

Cell[TextData[{
  StyleBox["BasisH[m, x]", "InlineInput"],
  " gives a vector space basis for ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(H\_m\), "(", 
          SuperscriptBox[
            StyleBox["R",
              FontWeight->"Bold",
              FontSlant->"Plain"], "n"], ")"}], TraditionalForm]]],
  ", the space of homogeneous harmonic polynomials on ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontWeight->"Bold",
            FontSlant->"Plain"], "n"], TraditionalForm]]],
  "of degree ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " is the dimension of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". The user must first set the dimension of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " to an positive integer value. Wrapping the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " command ",
  StyleBox["TableForm", "InlineInput"],
  " around ",
  StyleBox["BasisH[m, x]", "InlineInput"],
  " will produce an output display that is more readable than the usual list \
format:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDimension[x, 3]\)], "Input"],

Cell[BoxData[
    \(SetDimension::"Vector" \(\(:\)\(\ \)\) 
      "\!\(x\) will be considered to be a vector in \!\(3\)-dimensional real \
Euclidean space."\)], "Message"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[BasisH[4, x]]\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(3\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^4 - 
              30\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ \
x\_2\%2 + 35\ x\_2\%4\)},
          {\(3\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ \
x\_2\ x\_3 - 7\ x\_2\%3\ x\_3\)},
          {\(\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^4 - 
              5\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ x\
\_2\%2 - 5\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ \
x\_3\%2 + 35\ x\_2\%2\ x\_3\%2\)},
          {\(3\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ \
x\_2\ x\_3 - 7\ x\_2\ x\_3\%3\)},
          {\(3\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^4 - 
              30\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ \
x\_3\%2 + 35\ x\_3\%4\)},
          {\(3\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ \
x\_1\ x\_2 - 7\ x\_1\ x\_2\%3\)},
          {\(\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ x\_1\ \
x\_3 - 7\ x\_1\ x\_2\%2\ x\_3\)},
          {\(\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ x\_1\ \
x\_2 - 7\ x\_1\ x\_2\ x\_3\%2\)},
          {\(3\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ \
x\_1\ x\_3 - 7\ x\_1\ x\_3\%3\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Plus[ 
          Times[ 3, 
            Power[ 
              Norm[ x], 4]], 
          Times[ -30, 
            Power[ 
              Norm[ x], 2], 
            Power[ 
              Subscript[ x, 2], 2]], 
          Times[ 35, 
            Power[ 
              Subscript[ x, 2], 4]]], 
        Plus[ 
          Times[ 3, 
            Power[ 
              Norm[ x], 2], 
            Subscript[ x, 2], 
            Subscript[ x, 3]], 
          Times[ -7, 
            Power[ 
              Subscript[ x, 2], 3], 
            Subscript[ x, 3]]], 
        Plus[ 
          Power[ 
            Norm[ x], 4], 
          Times[ -5, 
            Power[ 
              Norm[ x], 2], 
            Power[ 
              Subscript[ x, 2], 2]], 
          Times[ -5, 
            Power[ 
              Norm[ x], 2], 
            Power[ 
              Subscript[ x, 3], 2]], 
          Times[ 35, 
            Power[ 
              Subscript[ x, 2], 2], 
            Power[ 
              Subscript[ x, 3], 2]]], 
        Plus[ 
          Times[ 3, 
            Power[ 
              Norm[ x], 2], 
            Subscript[ x, 2], 
            Subscript[ x, 3]], 
          Times[ -7, 
            Subscript[ x, 2], 
            Power[ 
              Subscript[ x, 3], 3]]], 
        Plus[ 
          Times[ 3, 
            Power[ 
              Norm[ x], 4]], 
          Times[ -30, 
            Power[ 
              Norm[ x], 2], 
            Power[ 
              Subscript[ x, 3], 2]], 
          Times[ 35, 
            Power[ 
              Subscript[ x, 3], 4]]], 
        Plus[ 
          Times[ 3, 
            Power[ 
              Norm[ x], 2], 
            Subscript[ x, 1], 
            Subscript[ x, 2]], 
          Times[ -7, 
            Subscript[ x, 1], 
            Power[ 
              Subscript[ x, 2], 3]]], 
        Plus[ 
          Times[ 
            Power[ 
              Norm[ x], 2], 
            Subscript[ x, 1], 
            Subscript[ x, 3]], 
          Times[ -7, 
            Subscript[ x, 1], 
            Power[ 
              Subscript[ x, 2], 2], 
            Subscript[ x, 3]]], 
        Plus[ 
          Times[ 
            Power[ 
              Norm[ x], 2], 
            Subscript[ x, 1], 
            Subscript[ x, 2]], 
          Times[ -7, 
            Subscript[ x, 1], 
            Subscript[ x, 2], 
            Power[ 
              Subscript[ x, 3], 2]]], 
        Plus[ 
          Times[ 3, 
            Power[ 
              Norm[ x], 2], 
            Subscript[ x, 1], 
            Subscript[ x, 3]], 
          Times[ -7, 
            Subscript[ x, 1], 
            Power[ 
              Subscript[ x, 3], 3]]]}]]], "Output"]
}, Closed]],

Cell[TextData[{
  "The option the option ",
  StyleBox["Orthonormal \[Rule] Ball", "InlineInput"],
  ", when used with ",
  StyleBox["BasisH", "InlineInput"],
  ", will produce a basis for ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(H\_m\), "(", 
          SuperscriptBox[
            StyleBox["R",
              FontWeight->"Bold",
              FontSlant->"Plain"], "n"], ")"}], TraditionalForm]]],
  "that is orthonormal with respect to the inner product on ",
  Cell[BoxData[
      \(TraditionalForm\`L\^2\)]],
  "(",
  StyleBox["B",
    FontSlant->"Italic"],
  ", ",
  StyleBox["dV",
    FontSlant->"Italic"],
  ") (here ",
  Cell[BoxData[
      \(TraditionalForm\`B\)]],
  " denotes the open unit ball in Euclidean space and ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " denotes volume measure on ",
  Cell[BoxData[
      \(TraditionalForm\`B\)]],
  "):"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[BasisH[4, x, Orthonormal \[Rule] Ball]]\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(3\/16\ \@\(11\/\[Pi]\)\ \((3\ \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^4 - 
                  30\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^\
2\ x\_2\%2 + 35\ x\_2\%4)\)\)},
          {\(\(-\(3\/4\)\)\ \@\(55\/\(2\ \[Pi]\)\)\ \((3\ \
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ x\_2\ x\_3 - 
                  7\ x\_2\%3\ x\_3)\)\)},
          {\(3\/8\ \@\(55\/\[Pi]\)\ \((\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^4 - 
                  8\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^\
2\ x\_2\%2 + 7\ x\_2\%4 - 
                  2\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^\
2\ x\_3\%2 + 14\ x\_2\%2\ x\_3\%2)\)\)},
          {\(\(-\(3\/4\)\)\ \@\(385\/\(2\ \[Pi]\)\)\ \((3\ \
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ x\_2\ x\_3 - 
                  3\ x\_2\%3\ x\_3 - 4\ x\_2\ x\_3\%3)\)\)},
          {\(3\/16\ \@\(385\/\[Pi]\)\ \((\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^4 - 
                  2\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^\
2\ x\_2\%2 + x\_2\%4 - 
                  8\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^\
2\ x\_3\%2 + 8\ x\_2\%2\ x\_3\%2 + 8\ x\_3\%4)\)\)},
          {\(\(-\(3\/4\)\)\ \@\(55\/\(2\ \[Pi]\)\)\ \((3\ \
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ x\_1\ x\_2 - 
                  7\ x\_1\ x\_2\%3)\)\)},
          {\(\(-\(3\/4\)\)\ \@\(55\/\[Pi]\)\ \((\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2\ x\_1\ x\_3 - 7\ x\_1\ x\_2\%2\ x\_3)\)\)},
          {\(\(-\(3\/4\)\)\ \@\(385\/\(2\ \[Pi]\)\)\ \((\
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ x\_1\ x\_2 - 
                  x\_1\ x\_2\%3 - 4\ x\_1\ x\_2\ x\_3\%2)\)\)},
          {\(\(-\(3\/4\)\)\ \@\(385\/\[Pi]\)\ \((\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2\ x\_1\ x\_3 - x\_1\ x\_2\%2\ x\_3 - 
                  2\ x\_1\ x\_3\%3)\)\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Times[ 
          Rational[ 3, 16], 
          Power[ 
            Times[ 11, 
              Power[ Pi, -1]], 
            Rational[ 1, 2]], 
          Plus[ 
            Times[ 3, 
              Power[ 
                Norm[ x], 4]], 
            Times[ -30, 
              Power[ 
                Norm[ x], 2], 
              Power[ 
                Subscript[ x, 2], 2]], 
            Times[ 35, 
              Power[ 
                Subscript[ x, 2], 4]]]], 
        Times[ 
          Rational[ -3, 4], 
          Power[ 
            Times[ 
              Rational[ 55, 2], 
              Power[ Pi, -1]], 
            Rational[ 1, 2]], 
          Plus[ 
            Times[ 3, 
              Power[ 
                Norm[ x], 2], 
              Subscript[ x, 2], 
              Subscript[ x, 3]], 
            Times[ -7, 
              Power[ 
                Subscript[ x, 2], 3], 
              Subscript[ x, 3]]]], 
        Times[ 
          Rational[ 3, 8], 
          Power[ 
            Times[ 55, 
              Power[ Pi, -1]], 
            Rational[ 1, 2]], 
          Plus[ 
            Power[ 
              Norm[ x], 4], 
            Times[ -8, 
              Power[ 
                Norm[ x], 2], 
              Power[ 
                Subscript[ x, 2], 2]], 
            Times[ 7, 
              Power[ 
                Subscript[ x, 2], 4]], 
            Times[ -2, 
              Power[ 
                Norm[ x], 2], 
              Power[ 
                Subscript[ x, 3], 2]], 
            Times[ 14, 
              Power[ 
                Subscript[ x, 2], 2], 
              Power[ 
                Subscript[ x, 3], 2]]]], 
        Times[ 
          Rational[ -3, 4], 
          Power[ 
            Times[ 
              Rational[ 385, 2], 
              Power[ Pi, -1]], 
            Rational[ 1, 2]], 
          Plus[ 
            Times[ 3, 
              Power[ 
                Norm[ x], 2], 
              Subscript[ x, 2], 
              Subscript[ x, 3]], 
            Times[ -3, 
              Power[ 
                Subscript[ x, 2], 3], 
              Subscript[ x, 3]], 
            Times[ -4, 
              Subscript[ x, 2], 
              Power[ 
                Subscript[ x, 3], 3]]]], 
        Times[ 
          Rational[ 3, 16], 
          Power[ 
            Times[ 385, 
              Power[ Pi, -1]], 
            Rational[ 1, 2]], 
          Plus[ 
            Power[ 
              Norm[ x], 4], 
            Times[ -2, 
              Power[ 
                Norm[ x], 2], 
              Power[ 
                Subscript[ x, 2], 2]], 
            Power[ 
              Subscript[ x, 2], 4], 
            Times[ -8, 
              Power[ 
                Norm[ x], 2], 
              Power[ 
                Subscript[ x, 3], 2]], 
            Times[ 8, 
              Power[ 
                Subscript[ x, 2], 2], 
              Power[ 
                Subscript[ x, 3], 2]], 
            Times[ 8, 
              Power[ 
                Subscript[ x, 3], 4]]]], 
        Times[ 
          Rational[ -3, 4], 
          Power[ 
            Times[ 
              Rational[ 55, 2], 
              Power[ Pi, -1]], 
            Rational[ 1, 2]], 
          Plus[ 
            Times[ 3, 
              Power[ 
                Norm[ x], 2], 
              Subscript[ x, 1], 
              Subscript[ x, 2]], 
            Times[ -7, 
              Subscript[ x, 1], 
              Power[ 
                Subscript[ x, 2], 3]]]], 
        Times[ 
          Rational[ -3, 4], 
          Power[ 
            Times[ 55, 
              Power[ Pi, -1]], 
            Rational[ 1, 2]], 
          Plus[ 
            Times[ 
              Power[ 
                Norm[ x], 2], 
              Subscript[ x, 1], 
              Subscript[ x, 3]], 
            Times[ -7, 
              Subscript[ x, 1], 
              Power[ 
                Subscript[ x, 2], 2], 
              Subscript[ x, 3]]]], 
        Times[ 
          Rational[ -3, 4], 
          Power[ 
            Times[ 
              Rational[ 385, 2], 
              Power[ Pi, -1]], 
            Rational[ 1, 2]], 
          Plus[ 
            Times[ 
              Power[ 
                Norm[ x], 2], 
              Subscript[ x, 1], 
              Subscript[ x, 2]], 
            Times[ -1, 
              Subscript[ x, 1], 
              Power[ 
                Subscript[ x, 2], 3]], 
            Times[ -4, 
              Subscript[ x, 1], 
              Subscript[ x, 2], 
              Power[ 
                Subscript[ x, 3], 2]]]], 
        Times[ 
          Rational[ -3, 4], 
          Power[ 
            Times[ 385, 
              Power[ Pi, -1]], 
            Rational[ 1, 2]], 
          Plus[ 
            Times[ 
              Power[ 
                Norm[ x], 2], 
              Subscript[ x, 1], 
              Subscript[ x, 3]], 
            Times[ -1, 
              Subscript[ x, 1], 
              Power[ 
                Subscript[ x, 2], 2], 
              Subscript[ x, 3]], 
            Times[ -2, 
              Subscript[ x, 1], 
              Power[ 
                Subscript[ x, 3], 3]]]]}]]], "Output"]
}, Closed]],

Cell[TextData[{
  "The option ",
  StyleBox["Orthonormal \[Rule] Sphere", "InlineInput"],
  ", when used with ",
  StyleBox["BasisH", "InlineInput"],
  ", will produce a basis for ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(H\_m\), "(", 
          SuperscriptBox[
            StyleBox["R",
              FontWeight->"Bold",
              FontSlant->"Plain"], "n"], ")"}], TraditionalForm]]],
  "that is orthonormal with respect to the inner product on ",
  Cell[BoxData[
      \(TraditionalForm\`\(L\^2\)(S, \ d\[Sigma])\)]],
  " (here ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " denotes the unit sphere in Euclidean space and \[Sigma] denotes \
normalized surface area measure on ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  "):"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[BasisH[4, x, Orthonormal \[Rule] Sphere]]\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(3\/8\ \((3\ \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^4 - 
                  30\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^\
2\ x\_2\%2 + 35\ x\_2\%4)\)\)},
          {\(\(-\(3\/2\)\)\ \@\(5\/2\)\ \((3\ \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2\ x\_2\ x\_3 - 7\ x\_2\%3\ x\_3)\)\)},
          {\(3\/4\ \@5\ \((\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^4 - 
                  8\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^\
2\ x\_2\%2 + 7\ x\_2\%4 - 
                  2\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^\
2\ x\_3\%2 + 14\ x\_2\%2\ x\_3\%2)\)\)},
          {\(\(-\(3\/2\)\)\ \@\(35\/2\)\ \((3\ \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2\ x\_2\ x\_3 - 3\ x\_2\%3\ x\_3 - 
                  4\ x\_2\ x\_3\%3)\)\)},
          {\(3\/8\ \@35\ \((\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^4 - 
                  2\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^\
2\ x\_2\%2 + x\_2\%4 - 
                  8\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^\
2\ x\_3\%2 + 8\ x\_2\%2\ x\_3\%2 + 8\ x\_3\%4)\)\)},
          {\(\(-\(3\/2\)\)\ \@\(5\/2\)\ \((3\ \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2\ x\_1\ x\_2 - 7\ x\_1\ x\_2\%3)\)\)},
          {\(\(-\(3\/2\)\)\ \@5\ \((\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2\ x\_1\ x\_3 - 7\ x\_1\ x\_2\%2\ x\_3)\)\)},
          {\(\(-\(3\/2\)\)\ \@\(35\/2\)\ \((\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2\ x\_1\ x\_2 - x\_1\ x\_2\%3 - 
                  4\ x\_1\ x\_2\ x\_3\%2)\)\)},
          {\(\(-\(3\/2\)\)\ \@35\ \((\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2\ x\_1\ x\_3 - x\_1\ x\_2\%2\ x\_3 - 
                  2\ x\_1\ x\_3\%3)\)\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Times[ 
          Rational[ 3, 8], 
          Plus[ 
            Times[ 3, 
              Power[ 
                Norm[ x], 4]], 
            Times[ -30, 
              Power[ 
                Norm[ x], 2], 
              Power[ 
                Subscript[ x, 2], 2]], 
            Times[ 35, 
              Power[ 
                Subscript[ x, 2], 4]]]], 
        Times[ 
          Rational[ -3, 2], 
          Power[ 
            Rational[ 5, 2], 
            Rational[ 1, 2]], 
          Plus[ 
            Times[ 3, 
              Power[ 
                Norm[ x], 2], 
              Subscript[ x, 2], 
              Subscript[ x, 3]], 
            Times[ -7, 
              Power[ 
                Subscript[ x, 2], 3], 
              Subscript[ x, 3]]]], 
        Times[ 
          Rational[ 3, 4], 
          Power[ 5, 
            Rational[ 1, 2]], 
          Plus[ 
            Power[ 
              Norm[ x], 4], 
            Times[ -8, 
              Power[ 
                Norm[ x], 2], 
              Power[ 
                Subscript[ x, 2], 2]], 
            Times[ 7, 
              Power[ 
                Subscript[ x, 2], 4]], 
            Times[ -2, 
              Power[ 
                Norm[ x], 2], 
              Power[ 
                Subscript[ x, 3], 2]], 
            Times[ 14, 
              Power[ 
                Subscript[ x, 2], 2], 
              Power[ 
                Subscript[ x, 3], 2]]]], 
        Times[ 
          Rational[ -3, 2], 
          Power[ 
            Rational[ 35, 2], 
            Rational[ 1, 2]], 
          Plus[ 
            Times[ 3, 
              Power[ 
                Norm[ x], 2], 
              Subscript[ x, 2], 
              Subscript[ x, 3]], 
            Times[ -3, 
              Power[ 
                Subscript[ x, 2], 3], 
              Subscript[ x, 3]], 
            Times[ -4, 
              Subscript[ x, 2], 
              Power[ 
                Subscript[ x, 3], 3]]]], 
        Times[ 
          Rational[ 3, 8], 
          Power[ 35, 
            Rational[ 1, 2]], 
          Plus[ 
            Power[ 
              Norm[ x], 4], 
            Times[ -2, 
              Power[ 
                Norm[ x], 2], 
              Power[ 
                Subscript[ x, 2], 2]], 
            Power[ 
              Subscript[ x, 2], 4], 
            Times[ -8, 
              Power[ 
                Norm[ x], 2], 
              Power[ 
                Subscript[ x, 3], 2]], 
            Times[ 8, 
              Power[ 
                Subscript[ x, 2], 2], 
              Power[ 
                Subscript[ x, 3], 2]], 
            Times[ 8, 
              Power[ 
                Subscript[ x, 3], 4]]]], 
        Times[ 
          Rational[ -3, 2], 
          Power[ 
            Rational[ 5, 2], 
            Rational[ 1, 2]], 
          Plus[ 
            Times[ 3, 
              Power[ 
                Norm[ x], 2], 
              Subscript[ x, 1], 
              Subscript[ x, 2]], 
            Times[ -7, 
              Subscript[ x, 1], 
              Power[ 
                Subscript[ x, 2], 3]]]], 
        Times[ 
          Rational[ -3, 2], 
          Power[ 5, 
            Rational[ 1, 2]], 
          Plus[ 
            Times[ 
              Power[ 
                Norm[ x], 2], 
              Subscript[ x, 1], 
              Subscript[ x, 3]], 
            Times[ -7, 
              Subscript[ x, 1], 
              Power[ 
                Subscript[ x, 2], 2], 
              Subscript[ x, 3]]]], 
        Times[ 
          Rational[ -3, 2], 
          Power[ 
            Rational[ 35, 2], 
            Rational[ 1, 2]], 
          Plus[ 
            Times[ 
              Power[ 
                Norm[ x], 2], 
              Subscript[ x, 1], 
              Subscript[ x, 2]], 
            Times[ -1, 
              Subscript[ x, 1], 
              Power[ 
                Subscript[ x, 2], 3]], 
            Times[ -4, 
              Subscript[ x, 1], 
              Subscript[ x, 2], 
              Power[ 
                Subscript[ x, 3], 2]]]], 
        Times[ 
          Rational[ -3, 2], 
          Power[ 35, 
            Rational[ 1, 2]], 
          Plus[ 
            Times[ 
              Power[ 
                Norm[ x], 2], 
              Subscript[ x, 1], 
              Subscript[ x, 3]], 
            Times[ -1, 
              Subscript[ x, 1], 
              Power[ 
                Subscript[ x, 2], 2], 
              Subscript[ x, 3]], 
            Times[ -2, 
              Subscript[ x, 1], 
              Power[ 
                Subscript[ x, 3], 3]]]]}]]], "Output"]
}, Closed]],

Cell[TextData[{
  "To produce an orthonormal basis for ",
  Cell[BoxData[
      \(TraditionalForm\`\(H\_m\)(S)\)]],
  ", the space of spherical harmonics on the unit sphere ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  ", with respect to the inner product on ",
  Cell[BoxData[
      \(TraditionalForm\`\(L\^2\)(S, \ d\[Sigma])\)]],
  ", use the option ",
  StyleBox["Orthonormal \[Rule] Sphere", "InlineInput"],
  " and in the result replace ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\)]],
  " with 1:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[
        BasisH[5, x, 
          Orthonormal \[Rule] 
            Sphere]]\  /. \ \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar] \[Rule] 1\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\(-\(1\/8\)\)\ \@11\ \((15\ x\_2 - 70\ x\_2\%3 + 
                  63\ x\_2\%5)\)\)},
          {\(\(-\(1\/8\)\)\ \@165\ \((x\_3 - 14\ x\_2\%2\ x\_3 + 
                  21\ x\_2\%4\ x\_3)\)\)},
          {\(\(-\(1\/4\)\)\ \@1155\ \((x\_2 - 4\ x\_2\%3 + 3\ x\_2\%5 - 
                  2\ x\_2\ x\_3\%2 + 6\ x\_2\%3\ x\_3\%2)\)\)},
          {\(\(-\(1\/8\)\)\ \@\(385\/2\)\ \((3\ x\_3 - 30\ x\_2\%2\ x\_3 + 
                  27\ x\_2\%4\ x\_3 - 4\ x\_3\%3 + 
                  36\ x\_2\%2\ x\_3\%3)\)\)},
          {\(\(-\(3\/8\)\)\ \@385\ \((x\_2 - 2\ x\_2\%3 + x\_2\%5 - 
                  8\ x\_2\ x\_3\%2 + 8\ x\_2\%3\ x\_3\%2 + 
                  8\ x\_2\ x\_3\%4)\)\)},
          {\(\(-\(3\/8\)\)\ \@\(77\/2\)\ \((5\ x\_3 - 10\ x\_2\%2\ x\_3 + 
                  5\ x\_2\%4\ x\_3 - 20\ x\_3\%3 + 20\ x\_2\%2\ x\_3\%3 + 
                  16\ x\_3\%5)\)\)},
          {\(\(-\(1\/8\)\)\ \@165\ \((x\_1 - 14\ x\_1\ x\_2\%2 + 
                  21\ x\_1\ x\_2\%4)\)\)},
          {\(1\/2\ \@1155\ \((x\_1\ x\_2\ x\_3 - 
                  3\ x\_1\ x\_2\%3\ x\_3)\)\)},
          {\(\(-\(1\/8\)\)\ \@\(385\/2\)\ \((x\_1 - 10\ x\_1\ x\_2\%2 + 
                  9\ x\_1\ x\_2\%4 - 4\ x\_1\ x\_3\%2 + 
                  36\ x\_1\ x\_2\%2\ x\_3\%2)\)\)},
          {\(3\/2\ \@385\ \((x\_1\ x\_2\ x\_3 - x\_1\ x\_2\%3\ x\_3 - 
                  2\ x\_1\ x\_2\ x\_3\%3)\)\)},
          {\(\(-\(3\/8\)\)\ \@\(77\/2\)\ \((x\_1 - 2\ x\_1\ x\_2\%2 + 
                  x\_1\ x\_2\%4 - 12\ x\_1\ x\_3\%2 + 
                  12\ x\_1\ x\_2\%2\ x\_3\%2 + 16\ x\_1\ x\_3\%4)\)\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Times[ 
          Rational[ -1, 8], 
          Power[ 11, 
            Rational[ 1, 2]], 
          Plus[ 
            Times[ 15, 
              Subscript[ x, 2]], 
            Times[ -70, 
              Power[ 
                Subscript[ x, 2], 3]], 
            Times[ 63, 
              Power[ 
                Subscript[ x, 2], 5]]]], 
        Times[ 
          Rational[ -1, 8], 
          Power[ 165, 
            Rational[ 1, 2]], 
          Plus[ 
            Subscript[ x, 3], 
            Times[ -14, 
              Power[ 
                Subscript[ x, 2], 2], 
              Subscript[ x, 3]], 
            Times[ 21, 
              Power[ 
                Subscript[ x, 2], 4], 
              Subscript[ x, 3]]]], 
        Times[ 
          Rational[ -1, 4], 
          Power[ 1155, 
            Rational[ 1, 2]], 
          Plus[ 
            Subscript[ x, 2], 
            Times[ -4, 
              Power[ 
                Subscript[ x, 2], 3]], 
            Times[ 3, 
              Power[ 
                Subscript[ x, 2], 5]], 
            Times[ -2, 
              Subscript[ x, 2], 
              Power[ 
                Subscript[ x, 3], 2]], 
            Times[ 6, 
              Power[ 
                Subscript[ x, 2], 3], 
              Power[ 
                Subscript[ x, 3], 2]]]], 
        Times[ 
          Rational[ -1, 8], 
          Power[ 
            Rational[ 385, 2], 
            Rational[ 1, 2]], 
          Plus[ 
            Times[ 3, 
              Subscript[ x, 3]], 
            Times[ -30, 
              Power[ 
                Subscript[ x, 2], 2], 
              Subscript[ x, 3]], 
            Times[ 27, 
              Power[ 
                Subscript[ x, 2], 4], 
              Subscript[ x, 3]], 
            Times[ -4, 
              Power[ 
                Subscript[ x, 3], 3]], 
            Times[ 36, 
              Power[ 
                Subscript[ x, 2], 2], 
              Power[ 
                Subscript[ x, 3], 3]]]], 
        Times[ 
          Rational[ -3, 8], 
          Power[ 385, 
            Rational[ 1, 2]], 
          Plus[ 
            Subscript[ x, 2], 
            Times[ -2, 
              Power[ 
                Subscript[ x, 2], 3]], 
            Power[ 
              Subscript[ x, 2], 5], 
            Times[ -8, 
              Subscript[ x, 2], 
              Power[ 
                Subscript[ x, 3], 2]], 
            Times[ 8, 
              Power[ 
                Subscript[ x, 2], 3], 
              Power[ 
                Subscript[ x, 3], 2]], 
            Times[ 8, 
              Subscript[ x, 2], 
              Power[ 
                Subscript[ x, 3], 4]]]], 
        Times[ 
          Rational[ -3, 8], 
          Power[ 
            Rational[ 77, 2], 
            Rational[ 1, 2]], 
          Plus[ 
            Times[ 5, 
              Subscript[ x, 3]], 
            Times[ -10, 
              Power[ 
                Subscript[ x, 2], 2], 
              Subscript[ x, 3]], 
            Times[ 5, 
              Power[ 
                Subscript[ x, 2], 4], 
              Subscript[ x, 3]], 
            Times[ -20, 
              Power[ 
                Subscript[ x, 3], 3]], 
            Times[ 20, 
              Power[ 
                Subscript[ x, 2], 2], 
              Power[ 
                Subscript[ x, 3], 3]], 
            Times[ 16, 
              Power[ 
                Subscript[ x, 3], 5]]]], 
        Times[ 
          Rational[ -1, 8], 
          Power[ 165, 
            Rational[ 1, 2]], 
          Plus[ 
            Subscript[ x, 1], 
            Times[ -14, 
              Subscript[ x, 1], 
              Power[ 
                Subscript[ x, 2], 2]], 
            Times[ 21, 
              Subscript[ x, 1], 
              Power[ 
                Subscript[ x, 2], 4]]]], 
        Times[ 
          Rational[ 1, 2], 
          Power[ 1155, 
            Rational[ 1, 2]], 
          Plus[ 
            Times[ 
              Subscript[ x, 1], 
              Subscript[ x, 2], 
              Subscript[ x, 3]], 
            Times[ -3, 
              Subscript[ x, 1], 
              Power[ 
                Subscript[ x, 2], 3], 
              Subscript[ x, 3]]]], 
        Times[ 
          Rational[ -1, 8], 
          Power[ 
            Rational[ 385, 2], 
            Rational[ 1, 2]], 
          Plus[ 
            Subscript[ x, 1], 
            Times[ -10, 
              Subscript[ x, 1], 
              Power[ 
                Subscript[ x, 2], 2]], 
            Times[ 9, 
              Subscript[ x, 1], 
              Power[ 
                Subscript[ x, 2], 4]], 
            Times[ -4, 
              Subscript[ x, 1], 
              Power[ 
                Subscript[ x, 3], 2]], 
            Times[ 36, 
              Subscript[ x, 1], 
              Power[ 
                Subscript[ x, 2], 2], 
              Power[ 
                Subscript[ x, 3], 2]]]], 
        Times[ 
          Rational[ 3, 2], 
          Power[ 385, 
            Rational[ 1, 2]], 
          Plus[ 
            Times[ 
              Subscript[ x, 1], 
              Subscript[ x, 2], 
              Subscript[ x, 3]], 
            Times[ -1, 
              Subscript[ x, 1], 
              Power[ 
                Subscript[ x, 2], 3], 
              Subscript[ x, 3]], 
            Times[ -2, 
              Subscript[ x, 1], 
              Subscript[ x, 2], 
              Power[ 
                Subscript[ x, 3], 3]]]], 
        Times[ 
          Rational[ -3, 8], 
          Power[ 
            Rational[ 77, 2], 
            Rational[ 1, 2]], 
          Plus[ 
            Subscript[ x, 1], 
            Times[ -2, 
              Subscript[ x, 1], 
              Power[ 
                Subscript[ x, 2], 2]], 
            Times[ 
              Subscript[ x, 1], 
              Power[ 
                Subscript[ x, 2], 4]], 
            Times[ -12, 
              Subscript[ x, 1], 
              Power[ 
                Subscript[ x, 3], 2]], 
            Times[ 12, 
              Subscript[ x, 1], 
              Power[ 
                Subscript[ x, 2], 2], 
              Power[ 
                Subscript[ x, 3], 2]], 
            Times[ 16, 
              Subscript[ x, 1], 
              Power[ 
                Subscript[ x, 3], 4]]]]}]]], "Output"]
}, Closed]],

Cell[TextData[{
  "BasisH is computed by using Theorem 5.25 of [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["ZonalHarmonic", "Subsection",
  CellTags->"ZonalHarmonic"],

Cell[TextData[{
  StyleBox["ZonalHarmonic[m, x, y]", "InlineInput"],
  " is the extended zonal harmonic ",
  Cell[BoxData[
      \(TraditionalForm\`\(Z\_m\)(x, y)\)]],
  "as defined by 8.7 of [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "]:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDimension[x, n]\)], "Input"],

Cell[BoxData[
    \(SetDimension::"Vector" \(\(:\)\(\ \)\) 
      "\!\(x\) will be considered to be a vector in \!\(n\)-dimensional real \
Euclidean space."\)], "Message"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ZonalHarmonic[5, x, y]\)], "Input"],

Cell[BoxData[
    \(1\/120\ n\ \((2 + n)\)\ \((4 + n)\)\ \((6 + n)\)\ \((8 + 
            n)\)\ \((x . y)\)\^5 - 
      1\/12\ n\ \((2 + n)\)\ \((4 + n)\)\ \((8 + 
            n)\)\ \((x . y)\)\^3\ \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2\ \[LeftDoubleBracketingBar]y\
\[RightDoubleBracketingBar]\^2 + 
      1\/8\ n\ \((2 + n)\)\ \((8 + n)\)\ x . 
          y\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^4\ \
\[LeftDoubleBracketingBar]y\[RightDoubleBracketingBar]\^4\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To obtain the zonal harmonic ",
  Cell[BoxData[
      \(TraditionalForm\`\(Z\_m\)(x, y)\)]],
  "as a homogeneous polynomial in ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " of degree ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " with pole ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  " on the unit sphere (as in Theorem 5.38 of [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "]), use ",
  StyleBox["ZonalHarmonic[m, x, y]", "InlineInput"],
  " and in the result replace ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[LeftDoubleBracketingBar]", 
          FormBox["z",
            "TraditionalForm"], "\[RightDoubleBracketingBar]"}], 
        TraditionalForm]]],
  " with 1:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDimension[x, 7]\)], "Input"],

Cell[BoxData[
    \(SetDimension::"Vector" \(\(:\)\(\ \)\) 
      "\!\(x\) will be considered to be a vector in \!\(7\)-dimensional real \
Euclidean space."\)], "Message"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ZonalHarmonic[6, x, 
        z]\  /. \ \[LeftDoubleBracketingBar]z\[RightDoubleBracketingBar] \
\[Rule] 1\)], "Input"],

Cell[BoxData[
    \(357\/16\ \((143\ \((x . z)\)\^6 - 
          143\ \((x . z)\)\^4\ \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2 + 
          33\ \((x . z)\)\^2\ \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^4 - \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^6)\)\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To obtain the zonal harmonic ",
  Cell[BoxData[
      \(TraditionalForm\`\(Z\_m\)(x, z)\)]],
  " as an element of ",
  Cell[BoxData[
      \(TraditionalForm\`\(H\_m\)(S)\)]],
  " as originally defined in Chapter 5 of [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "], use ",
  StyleBox["ZonalHarmonic[m,x,z]", "InlineInput"],
  " and in the result replace \[LeftDoubleBracketingBar]",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "\[RightDoubleBracketingBar] and ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[LeftDoubleBracketingBar]", 
          FormBox["z",
            "TraditionalForm"], "\[RightDoubleBracketingBar]"}], 
        TraditionalForm]]],
  " with 1:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ZonalHarmonic[8, x, 
        z]\  /. \ {\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar] \
\[Rule] 1, \[LeftDoubleBracketingBar]z\[RightDoubleBracketingBar] \[Rule] 
          1}\)], "Input"],

Cell[BoxData[
    \(693\/128\ \((7 - 364\ \((x . z)\)\^2 + 2730\ \((x . z)\)\^4 - 
          6188\ \((x . z)\)\^6 + 4199\ \((x . z)\)\^8)\)\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["DimensionH", "Subsection",
  CellTags->"DimensionH"],

Cell[TextData[{
  StyleBox["DimensionH[m, n]", "InlineInput"],
  " is the vector space dimension of ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(H\_m\), "(", 
          SuperscriptBox[
            StyleBox["R",
              FontWeight->"Bold",
              FontSlant->"Plain"], "n"], ")"}], TraditionalForm]]],
  ", the space of harmonic polynomials on ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontWeight->"Bold",
            FontSlant->"Plain"], "n"], TraditionalForm]]],
  "homogeneous of degree ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DimensionH[12, 100]\)], "Input"],

Cell[BoxData[
    \(3901030682812965\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["DimensionH", "InlineInput"],
  " is computed by using Proposition 5.8 of [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Inversion and the Kelvin Transform", "Section",
  CellTags->"Inversion and the Kelvin Transform"],

Cell[CellGroupData[{

Cell["Reflection", "Subsection",
  CellTags->"Inversion"],

Cell[TextData[{
  StyleBox["Reflection[x]", "InlineInput"],
  " is the reflection of a vector ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " with respect to the unit sphere. Thus the reflection of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " equals ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\/\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^\
2\),
          FontSize->16], TraditionalForm]]],
  ". The argument of ",
  StyleBox["Reflection", "InlineInput"],
  " can be either an expression representing a vector or a list of \
coordinates for a vector:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reflection[2  x + y]\)], "Input"],

Cell[BoxData[
    \(\(2\ x + y\)\/\[LeftDoubleBracketingBar]2\ x + y\
\[RightDoubleBracketingBar]\^2\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reflection[{1, \(-2\), 5, \ 11}]\)], "Input"],

Cell[BoxData[
    \({1\/151, \(-\(2\/151\)\), 5\/151, 11\/151}\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Reflection[x, Sphere[r, c]]", "InlineInput"],
  " is the reflection of a vector ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " with respect to the sphere with radius ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " centered at ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  ". Here each of  ",
  StyleBox["x", "InlineInput"],
  " and ",
  StyleBox["c", "InlineInput"],
  " can be either an expression representing a vector or a list of \
coordinates for a vector:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reflection[{2, 4, \ 5}, \ Sphere[7, \ {3, \ 1, \ 6}]]\)], "Input"],

Cell[BoxData[
    \({\(-\(16\/11\)\), 158\/11, 17\/11}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reflection[2  x + y, \ Sphere[3, \ z]]\)], "Input"],

Cell[BoxData[
    \(z + \(9\ \((2\ x + y - z)\)\)\/\[LeftDoubleBracketingBar]2\ x + y - z\
\[RightDoubleBracketingBar]\^2\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Reflection[x, Sphere[r, c]]", "InlineInput"],
  " is computed using equation 4.13 in [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"],

Cell[TextData[{
  StyleBox["Reflection[x, Hyperplane[b, t]]", "InlineInput"],
  " is the reflection of a vector ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " with respect to the hyperplane consisting of those vectors whose inner \
product with ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  " equals ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ". In other words, if ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " denotes the dimension of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " (which must equal the dimension of ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  "), then the reflection is taken with respect to the hyperplane {",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " \[Epsilon] ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontWeight->"Bold",
            FontSlant->"Plain"], "n"], TraditionalForm]]],
  ": ",
  Cell[BoxData[
      \(TraditionalForm\`b . y = t\)]],
  "}. Here each of  ",
  StyleBox["x", "InlineInput"],
  " and ",
  StyleBox["b", "InlineInput"],
  " can be either an expression representing a vector or a list of \
coordinates for a vector:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reflection[x\ , \ Hyperplane[{1, \ 4, 5}, \ 7]]\)], "Input"],

Cell[BoxData[
    \({1\/21\ \((7 + 20\ x\_1 - 4\ x\_2 - 5\ x\_3)\), 
      1\/21\ \((28 - 4\ x\_1 + 5\ x\_2 - 20\ x\_3)\), 
      1\/21\ \((35 - 5\ x\_1 - 20\ x\_2 - 4\ x\_3)\)}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reflection[{x\_1, x\_2}, \ Hyperplane[{4, 5}, \ 7]]\)], "Input"],

Cell[BoxData[
    \({1\/41\ \((56 + 9\ x\_1 - 40\ x\_2)\), 
      1\/41\ \((70 - 40\ x\_1 - 9\ x\_2)\)}\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Reflection[x, Hyperplane[b, t]]", "InlineInput"],
  " is computed using Exercise 9 on page 71 of [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Kelvin", "Subsection",
  CellTags->"Kelvin"],

Cell[TextData[{
  StyleBox["Kelvin[u, x]", "InlineInput"],
  " is the Kelvin transform of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ", thought of as a function of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDimension[x, n]\)], "Input"],

Cell[BoxData[
    \(SetDimension::"Vector" \(\(:\)\(\ \)\) 
      "\!\(x\) will be considered to be a vector in \!\(n\)-dimensional real \
Euclidean space."\)], "Message"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Kelvin[\((x . y)\)\^2 + x\_3\^5\ Norm[x], x]\)], "Input"],

Cell[BoxData[
    \(\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^\(\(-9\) - n\)\ \
\((\((x . y)\)\^2\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^7 \
+ x\_3\%5)\)\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Phi", "Subsection",
  CellTags->"Phi"],

Cell[TextData[{
  StyleBox["\[CapitalPhi][z]", "InlineInput"],
  " is is the modified inversion introduced on page 154 of [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "]. The modified inversion \[CapitalPhi] is defined by"
}], "Text"],

Cell[TextData[{
  "\[CapitalPhi](z) = 2",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[
            FractionBox[
              RowBox[{"z", "-", 
                StyleBox["S",
                  FontWeight->"Bold",
                  FontSlant->"Plain"]}], 
              SuperscriptBox[
                RowBox[{"\[LeftDoubleBracketingBar]", 
                  RowBox[{"z", "-", 
                    StyleBox["S",
                      FontWeight->"Bold",
                      FontSlant->"Plain"]}], "\[RightDoubleBracketingBar]"}], 
                "2"]],
            FontSize->16], " ", "+", " "}], TraditionalForm]]],
  StyleBox["S",
    FontWeight->"Bold"],
  ","
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "where ",
  StyleBox["S",
    FontWeight->"Bold"],
  " is the south pole (0, 0, ..., 0, -1). The modified inversion \
\[CapitalPhi] is useful for translating questions about harmonic functions on \
balls to questions about harmonic functions on half-spaces, and vice versa."
}], "Text"],

Cell[TextData[{
  "Here is a proof of that \[CapitalPhi](\[CapitalPhi](",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  ")) = ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  ", as claimed in Proposition 7.18 (a) of [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "]:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CapitalPhi][z]\)], "Input"],

Cell[BoxData[
    \(SetDimension::"Vector" \(\(:\)\(\ \)\) 
      "\!\(S\) will be considered to be a vector in \
\!\(Dimension[z]\)-dimensional real Euclidean space."\)], "Message"],

Cell[BoxData[
    \(S + \(2\ \((\(-S\) + z)\)\)\/\[LeftDoubleBracketingBar]\(-S\) + z\
\[RightDoubleBracketingBar]\^2\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CapitalPhi][%]\)], "Input"],

Cell[BoxData[
    \(z\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Another, and often more convenient, form of ",
  StyleBox["\[CapitalPhi]", "InlineInput"],
  " is given by ",
  StyleBox["\[CapitalPhi][x, y]", "InlineInput"],
  ". Here ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " is a vector, ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " is a real number, and thus (",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  ") is a vector in a Euclidean space whose dimension is one more than the \
dimension of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "."
}], "Text"],

Cell[TextData[{
  "Here is a proof of the assertion of Exercise 6 in Chapter 7 of [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "], which asserts that"
}], "Text"],

Cell[TextData[{
  "1 - ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftDoubleBracketingBar]\[CapitalPhi](x, \ y)\
\[RightDoubleBracketingBar]\^2\)]],
  " = ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(4  
                y\)\/\(\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\
\^2 + \ \((y\  + \ 1)\)\^2\)\),
          FontSize->16], TraditionalForm]]],
  ":"
}], "Text",
  TextAlignment->Center],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CapitalPhi][x, y]\)], "Input"],

Cell[BoxData[
    \({\(2\ x\)\/\(\((1 + y)\)\^2 + \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2\), \(-1\) + \(2\ \((1 + y)\)\)\/\(\((1 + \
y)\)\^2 + \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\)}\)], \
"Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(1 - \[LeftDoubleBracketingBar]%\[RightDoubleBracketingBar]\^2\)], \
"Input"],

Cell[BoxData[
    \(\(4\ y\)\/\(1 + 2\ y + y\^2 + \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2\)\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["KelvinM", "Subsection",
  CellTags->"KelvinM"],

Cell[TextData[{
  StyleBox["KelvinM[u, z]", "InlineInput"],
  " is the modified Kelvin transform defined to be equal to"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{\(2\^\(\((n - 2)\)/2\)\), " ", 
        SuperscriptBox[
          RowBox[{"\[LeftDoubleBracketingBar]", 
            RowBox[{"z", " ", "-", " ", 
              StyleBox["S",
                FontWeight->"Bold",
                FontSlant->"Plain"]}], "\[RightDoubleBracketingBar]"}], \(2 - 
            n\)], " ", \(\(u(\[CapitalPhi](z))\)\(.\)\)}], 
      TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "This modified Kelvin transform is defined on page 155 of [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "]. Here is a proof of the assertion made there that the modified Kelvin \
transform is its own inverse:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDimension[z, n]\)], "Input"],

Cell[BoxData[
    \(SetDimension::"Vector" \(\(:\)\(\ \)\) 
      "\!\(z\) will be considered to be a vector in \!\(n\)-dimensional real \
Euclidean space."\)], "Message"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(KelvinM[u[z], z]\)], "Input"],

Cell[BoxData[
    \(2\^\(\(-1\) + n\/2\)\ \[LeftDoubleBracketingBar]\(-S\) + z\
\[RightDoubleBracketingBar]\^\(2 - n\)\ u[
        S + \(2\ \((\(-S\) + z)\)\)\/\[LeftDoubleBracketingBar]\(-S\) + z\
\[RightDoubleBracketingBar]\^2]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(KelvinM[%, \ z]\)], "Input"],

Cell[BoxData[
    \(\((1\/\[LeftDoubleBracketingBar]\(-S\) + \
z\[RightDoubleBracketingBar])\)\^\(-n\)\ \[LeftDoubleBracketingBar]\(-S\) + z\
\[RightDoubleBracketingBar]\^\(-n\)\ u[z]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PowerExpand[%]\)], "Input"],

Cell[BoxData[
    \(u[z]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Another form of ",
  StyleBox["KelvinM", "InlineInput"],
  " is given by ",
  StyleBox["KelvinM[u, x, y]", "InlineInput"],
  ". Here ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " is a vector, ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " is a real variable, and ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " is a function of (",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  "), which is a vector in a Euclidean space whose dimension is one more than \
the dimension of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDimension[x, n - 1]\)], "Input"],

Cell[BoxData[
    \(SetDimension::"Vector" \(\(:\)\(\ \)\) 
      "\!\(x\) will be considered to be a vector in \!\(\(\(-1\)\) + \
n\)-dimensional real Euclidean space."\)], "Message"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(KelvinM[x[4], x, y]\)], "Input"],

Cell[BoxData[
    \(2\^\(n/2\)\ \((\((1 + y)\)\^2 + \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2)\)\^\(\(-n\)/2\)\ x\_4\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(KelvinM[z[4], z]\)], "Input"],

Cell[BoxData[
    \(2\^\(\(-1\) + n\/2\)\ \[LeftDoubleBracketingBar]\(-S\) + z\
\[RightDoubleBracketingBar]\^\(-n\)\ \((\(-2\)\ S\_4 + \
\[LeftDoubleBracketingBar]\(-S\) + z\[RightDoubleBracketingBar]\^2\ S\_4 + 
          2\ z\_4)\)\)], "Output"]
}, Closed]],

Cell[TextData[{
  "If we had used the input ",
  StyleBox["KelvinM[ z[4], z ]", "InlineInput"],
  ", the result would have included terms of the form ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["S",
            FontWeight->"Bold",
            FontSlant->"Plain"], "4"], TraditionalForm]]],
  ", which denotes the fourth coordinate of the south pole ",
  StyleBox["S",
    FontWeight->"Bold"],
  ". Of course ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["S",
            FontWeight->"Bold",
            FontSlant->"Plain"], "4"], TraditionalForm]]],
  " equals either 0 or -1, but since the dimension of ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  " has been set to equal the symbol ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  ", the computer has no way of determining whether or not ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " equals 4. With the input ",
  StyleBox["KelvinM[ z[4], z ]", "InlineInput"],
  " there is no ambiguity; ",
  Cell[BoxData[
      \(TraditionalForm\`x\_4\)]],
  " cannot be the last coordinate, because the last coordinate is denoted by \
",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  "."
}], "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Kernels", "Section",
  CellTags->"Kernels"],

Cell[CellGroupData[{

Cell["PoissonKernel", "Subsection",
  CellTags->"PoissonKernel"],

Cell[TextData[{
  StyleBox["PoissonKernel[x, y]", "InlineInput"],
  " is the extended Poisson kernel ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  "(",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ",",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  ") for the unit ball as defined by Equation 6.21 of [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "]:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDimension[x, n]\)], "Input"],

Cell[BoxData[
    \(SetDimension::"Vector" \(\(:\)\(\ \)\) 
      "\!\(x\) will be considered to be a vector in \!\(n\)-dimensional real \
Euclidean space."\)], "Message"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PoissonKernel[x, y]\)], "Input"],

Cell[BoxData[
    \(\((1 - \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ \
\[LeftDoubleBracketingBar]y\[RightDoubleBracketingBar]\^2)\)\ \((1 - 2\ x . y \
+ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ \
\[LeftDoubleBracketingBar]y\[RightDoubleBracketingBar]\^2)\)\^\(\(-n\)/2\)\)],\
 "Output"]
}, Closed]],

Cell[TextData[{
  "The usual Poisson kernel ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  "(",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", \[Zeta]), where \[Zeta] lies on the unit sphere, can be obtained by \
replacing \[LeftDoubleBracketingBar]\[Zeta]\[RightDoubleBracketingBar] with \
1:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PoissonKernel[
        x, \[Zeta]]\  /. \ \[LeftDoubleBracketingBar]\[Zeta]\
\[RightDoubleBracketingBar] \[Rule] \ 1\)], "Input"],

Cell[BoxData[
    \(\((1 - \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2)\)\ \
\((1 - 2\ x . \[Zeta] + \
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2)\)\^\(\(-n\)/2\)\)],\
 "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["PoissonKernelH", "Subsection",
  CellTags->"PoisssonKernelH"],

Cell[TextData[{
  StyleBox["PoissonKernelH[z, w]", "InlineInput"],
  " is the extended Poisson kernel ",
  Cell[BoxData[
      \(TraditionalForm\`P\_H\)]],
  "(",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  ") for the upper half-space ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  ", as defined by Equation 8.22 of [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "]:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDimension[z, 5]\)], "Input"],

Cell[BoxData[
    \(SetDimension::"Vector" \(\(:\)\(\ \)\) 
      "\!\(z\) will be considered to be a vector in \!\(5\)-dimensional real \
Euclidean space."\)], "Message"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PoissonKernelH[z, w]\)], "Input"],

Cell[BoxData[
    \(\(3\ \((w\_5 + z\_5)\)\)\/\(4\ \[Pi]\^2\ \((\(-2\)\ w . z + \
\[LeftDoubleBracketingBar]w\[RightDoubleBracketingBar]\^2 + \
\[LeftDoubleBracketingBar]z\[RightDoubleBracketingBar]\^2 + 4\ w\_5\ \
z\_5)\)\^\(5/2\)\)\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The usual Poisson kernel ",
  Cell[BoxData[
      \(TraditionalForm\`P\_H\)]],
  "(",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  ") for the upper half-space, where we think of ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(w\)\(\ \)\)\)]],
  "\[Epsilon] ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]\)]],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  ", can be obtained by replacing the last coordinate of ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  " with 0:."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(%\  /. \ w\_5 \[Rule] 0\)], "Input"],

Cell[BoxData[
    \(\(3\ z\_5\)\/\(4\ \[Pi]\^2\ \((\(-2\)\ w . z + \
\[LeftDoubleBracketingBar]w\[RightDoubleBracketingBar]\^2 + \
\[LeftDoubleBracketingBar]z\[RightDoubleBracketingBar]\^2)\)\^\(5/2\)\)\)], \
"Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["PoissonKernelH[x, y, t, u]", "InlineInput"],
  " equals ",
  Cell[BoxData[
      \(TraditionalForm\`P\_H\)]],
  StyleBox["(",
    FontSize->14],
  "(",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  "), (",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ")",
  StyleBox[")",
    FontSize->16],
  " and thus is another format for the extended Poisson kernel on the upper \
half-space. Here ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " denote vectors, and ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " denote nonnegative numbers. Note that if we want to work in the upper \
half-space of ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontWeight->"Bold",
            FontSlant->"Plain"], "n"], TraditionalForm]]],
  ", then the dimension of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " should be set to ",
  Cell[BoxData[
      \(TraditionalForm\`n - 1\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDimension[x, n - 1]\)], "Input"],

Cell[BoxData[
    \(SetDimension::"Vector" \(\(:\)\(\ \)\) 
      "\!\(x\) will be considered to be a vector in \!\(\(\(-1\)\) + \
n\)-dimensional real Euclidean space."\)], "Message"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PoissonKernelH[x, y, t, u]\)], "Input"],

Cell[BoxData[
    \(\(2\ \((u + y)\)\ \((\((u + y)\)\^2 + \[LeftDoubleBracketingBar]\(-t\) \
+ x\[RightDoubleBracketingBar]\^2)\)\^\(\(-n\)/2\)\)\/\(n\ Volume[n]\)\)], \
"Output"]
}, Closed]],

Cell[TextData[{
  "The usual Poisson kernel  ",
  Cell[BoxData[
      \(TraditionalForm\`P\_H\)]],
  StyleBox["(",
    FontSize->14],
  "(",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  "), ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  StyleBox[")",
    FontSize->16],
  "  for the upper half-space, where ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(t\)\(\ \)\)\)]],
  "\[Epsilon] ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]\)]],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  ", can be setting the last argument in this format to 0:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PoissonKernelH[x, y, t, 0]\)], "Input"],

Cell[BoxData[
    \(\(2\ y\ \((y\^2 + \[LeftDoubleBracketingBar]\(-t\) + x\
\[RightDoubleBracketingBar]\^2)\)\^\(\(-n\)/2\)\)\/\(n\ Volume[n]\)\)], \
"Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["BergmanKernel", "Subsection",
  CellTags->"BergmanKernel"],

Cell[TextData[{
  StyleBox["BergmanKernel[x, y]", "InlineInput"],
  " is the reproducing kernel for the harmonic Bergman space of the unit \
ball:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDimension[x, 10]\)], "Input"],

Cell[BoxData[
    \(SetDimension::"Vector" \(\(:\)\(\ \)\) 
      "\!\(x\) will be considered to be a vector in \!\(10\)-dimensional real \
Euclidean space."\)], "Message"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(BergmanKernel[x, y]\)], "Input"],

Cell[BoxData[
    \(\(12\ \((10 + 8\ \((\(-3\) + x . y)\)\ \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2\ \[LeftDoubleBracketingBar]y\
\[RightDoubleBracketingBar]\^2 + 6\ \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^4\ \[LeftDoubleBracketingBar]y\
\[RightDoubleBracketingBar]\^4)\)\)\/\(\[Pi]\^5\ \((1 - 2\ x . y + \
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ \
\[LeftDoubleBracketingBar]y\[RightDoubleBracketingBar]\^2)\)\^6\)\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["BergmanKernel", "InlineInput"],
  " is computed using Theorem 8.13 of [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["BergmanKernelH", "Subsection",
  CellTags->"BergmanKernelH"],

Cell[TextData[{
  StyleBox["BergmanKernelH[z, w]", "InlineInput"],
  " is the reproducing kernel for the harmonic Bergman space of the upper \
half-space:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDimension[z, 10]\)], "Input"],

Cell[BoxData[
    \(SetDimension::"Vector" \(\(:\)\(\ \)\) 
      "\!\(z\) will be considered to be a vector in \!\(10\)-dimensional real \
Euclidean space."\)], "Message"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(BergmanKernelH[z, w]\)], "Input"],

Cell[BoxData[
    \(\(48\ \((2\ w . z - \[LeftDoubleBracketingBar]w\
\[RightDoubleBracketingBar]\^2 - \[LeftDoubleBracketingBar]z\
\[RightDoubleBracketingBar]\^2 + 16\ w\_10\ z\_10 + 10\ \((w\_10\%2 + \
z\_10\%2)\))\)\)\/\(\[Pi]\^5\ \((2\ w . z - \[LeftDoubleBracketingBar]w\
\[RightDoubleBracketingBar]\^2 - \[LeftDoubleBracketingBar]z\
\[RightDoubleBracketingBar]\^2 - 4\ w\_10\ z\_10)\)\^6\)\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["BergmanKernelH[x, y, t, u]", "InlineInput"],
  " is another format for the reproducing kernel for the harmonic Bergman \
space of the upper half-space. Here ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " denote vectors, ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " denote nonnegative numbers, and the kernel is evaluated at ",
  StyleBox["(",
    FontSize->14],
  "(",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  "), (",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ")",
  StyleBox[")",
    FontSize->16],
  ". Note that if we want to work in the upper half-space of ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontWeight->"Bold",
            FontSlant->"Plain"], "n"], TraditionalForm]]],
  ", then the dimension of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " should be set to ",
  Cell[BoxData[
      \(TraditionalForm\`n - 1\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDimension[x, n - 1]\)], "Input"],

Cell[BoxData[
    \(SetDimension::"Vector" \(\(:\)\(\ \)\) 
      "\!\(x\) will be considered to be a vector in \!\(\(\(-1\)\) + \
n\)-dimensional real Euclidean space."\)], "Message"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(BergmanKernelH[x, y, t, u]\)], "Input"],

Cell[BoxData[
    \(\(4\ \((\((\(-1\) + n)\)\ \((u + y)\)\^2 - \
\[LeftDoubleBracketingBar]\(-t\) + x\[RightDoubleBracketingBar]\^2)\)\ \
\((\((u + y)\)\^2 + \[LeftDoubleBracketingBar]\(-t\) + x\
\[RightDoubleBracketingBar]\^2)\)\^\(\(-1\) - n\/2\)\)\/\(n\ Volume[n]\)\)], \
"Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["BergmanKernelH", "InlineInput"],
  " is computed by using Theorem 8.24 of [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Miscellaneous", "Section",
  CellTags->"Miscellaneous"],

Cell[CellGroupData[{

Cell["BergmanProjection", "Subsection",
  CellTags->"BergmanProjection"],

Cell[TextData[{
  StyleBox["BergmanProjection[u, x]", "InlineInput"],
  " is the orthogonal projection of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  "onto ",
  Cell[BoxData[
      \(TraditionalForm\`\(b\^2\)(B)\)]],
  ", the harmonic Bergman space of the unit ball (see Chapter 8 of [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "]). Here ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " must be a polynomial function of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDimension[x, 5]\)], "Input"],

Cell[BoxData[
    \(SetDimension::"Vector" \(\(:\)\(\ \)\) 
      "\!\(x\) will be considered to be a vector in \!\(5\)-dimensional real \
Euclidean space."\)], "Message"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(BergmanProjection[x\_1\^5\ x\_2\^3, x]\)], "Input"],

Cell[BoxData[
    \(\(3\ x\_1\ x\_2\)\/143 - 
      3\/221\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^6\ x\_1\
\ x\_2 + 2\/17\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^4\ \
x\_1\%3\ x\_2 - 
      3\/17\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ \
x\_1\%5\ x\_2 + 
      1\/17\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^4\ x\_1\ \
x\_2\%3 - 
      10\/17\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ x\_1\
\%3\ x\_2\%3 + x\_1\%5\ x\_2\%3 + 
      1\/17\ \((\(-\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\)\
\ x\_1\ x\_2 + 2\ x\_1\%3\ x\_2 + 
            x\_1\ x\_2\%3)\) + \(135\ \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^4\ x\_1\ x\_2 - 660\ \[LeftDoubleBracketingBar]x\
\[RightDoubleBracketingBar]\^2\ x\_1\%3\ x\_2 + 429\ x\_1\%5\ x\_2 - 330\ \
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ x\_1\ x\_2\%3 + \
1430\ x\_1\%3\ x\_2\%3\)\/2717\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["BergmanProjection", "InlineInput"],
  " is computed by using Corollary 8.15 of [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["HarmonicConjugate", "Subsection",
  CellTags->"HarmonicConjugate"],

Cell[TextData[{
  StyleBox["HarmonicConjugate[u, x, y]", "InlineInput"],
  " is the harmonic conjugate of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " on ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontWeight->"Bold",
            FontSlant->"Plain"], "2"], TraditionalForm]]],
  ", where the coordinates in ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["R",
            FontWeight->"Bold",
            FontSlant->"Plain"], "2"], TraditionalForm]]],
  "are denoted by ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " is a harmonic function of (",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  "):"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(HarmonicConjugate[15  x\^2\ y + 12  x\^3\ y - 5  y\^3 - 12  x\ y\^3, x, 
      y]\)], "Input"],

Cell[BoxData[
    \(\(-x\^3\)\ \((5 + 3\ x)\) - 
      3\ y\^2\ \((\(-5\)\ x - 6\ x\^2 + y\^2)\)\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["HarmonicConjugate", "InlineInput"],
  " is computed by using Exercise 11 in Chapter 1 of [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Schwarz", "Subsection",
  CellTags->"Schwarz"],

Cell[TextData[{
  StyleBox["Schwarz[x]", "InlineInput"],
  " is the maximum of |",
  Cell[BoxData[
      \(TraditionalForm\`u(x)\)]],
  "|, where ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " ranges over all harmonic functions on the unit ball (in the Euclidean \
space whose dimension is determined by ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ") with ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  "(0) = 0 and |",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  "| < 1 on the ball. Thus, in the notation used in Theorem 6.24 of [ABR] to \
present the Harmonic Schwarz Lemma, ",
  StyleBox["Schwarz[x]", "InlineInput"],
  " equals ",
  Cell[BoxData[
      \(TraditionalForm\`U\)]],
  "(\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar] ",
  StyleBox["N",
    FontWeight->"Bold"],
  ").  The user must first set the dimension of the Euclidean space to a \
positive integer value:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDimension[x, 5]\)], "Input"],

Cell[BoxData[
    \(SetDimension::"Vector" \(\(:\)\(\ \)\) 
      "\!\(x\) will be considered to be a vector in \!\(5\)-dimensional real \
Euclidean space."\)], "Message"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Schwarz[x]\)], "Input"],

Cell[BoxData[
    \(\(\(-2\) - 3\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2 \
+ 3\ \[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^4 + 2\ \
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^6 + 2\ \@\(1 + \
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\) + 2\ \
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\ \@\(1 + \
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2\)\)\/\(2\ \
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^3\ \((1 + \
\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar]\^2)\)\^\(3/2\)\)\)], \
"Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Schwarz[x]", "InlineInput"],
  " is computed by evaluating the Poisson integral that defines ",
  Cell[BoxData[
      \(TraditionalForm\`U\)]],
  "(\[LeftDoubleBracketingBar]x\[RightDoubleBracketingBar] ",
  StyleBox["N",
    FontWeight->"Bold"],
  "), iterating an appropriate formula from Appendix A of [",
  ButtonBox["ABR",
    ButtonData:>"ABR",
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Togetherness", "Subsection",
  CellTags->"TurnOff and TurnOn"],

Cell[TextData[{
  "When not using the HFT.m software package, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " might tell the user that the result of a calculation is ",
  Cell[BoxData[
      \(TraditionalForm\`t\^2 + \((1 - t)\)\ \((1\  + \ t)\)\)]],
  ".  Of course the user will easily recognize that the last quantity equals \
1, but with more complicated results the user will need to apply appropriate \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands (such as ",
  StyleBox["Simplify", "InlineInput"],
  ", ",
  StyleBox["Expand", "InlineInput"],
  ", or ",
  StyleBox["Together", "InlineInput"],
  ") to get the result in simplest form.  Applying ",
  StyleBox["Simplify", "InlineInput"],
  " to all ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " output is poor practice, because ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can take a long time to realize that some expressions cannot be  \
simplified. For almost all output generated by the HFT.m package,  applying \
",
  StyleBox["Together", "InlineInput"],
  " to the result and all its subexpressions puts  it in simplest form.  Thus \
the HFT.m package redefines the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " variable ",
  StyleBox["$Post", "InlineInput"],
  " so that for each output ",
  Cell[BoxData[
      \(TraditionalForm\`X\)]],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will display either ",
  Cell[BoxData[
      \(TraditionalForm\`X\)]],
  " or the result of applying ",
  StyleBox["Together", "InlineInput"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`X\)]],
  " and all its subexpressions, whichever is shorter (if the user had defined \
",
  StyleBox["$Post", "InlineInput"],
  " before starting the HFT.m package, the HFT.m version of ",
  StyleBox["$Post", "InlineInput"],
  " is composed with the user's). This procedure is invisible to the user and \
usually requires only a short amount of computer time. If you want to turn \
off this feature, use the command ",
  StyleBox["TurnOff[Togetherness]", "InlineInput"],
  " (if the user had defined ",
  StyleBox["$Post", "InlineInput"],
  " before starting the HFT.m package, this restores the user's version).  \
The command ",
  StyleBox["TurnOn[Togetherness]", "InlineInput"],
  " turns this feature back on again."
}], "Text"],

Cell[TextData[{
  "If ",
  StyleBox["Homogeneous", "InlineInput"],
  " or ",
  StyleBox["Taylor", "InlineInput"],
  " is used to find an expansion about a point other than the origin, then ",
  StyleBox["Togetherness", "InlineInput"],
  " will be automatically turned off. If this were not done then, for \
example, the last output in the ",
  StyleBox["Taylor",
    FontSlant->"Italic"],
  " subsection earlier in this notebook would be simplified to 1 + ",
  Cell[BoxData[
      \(TraditionalForm\`\(x\_1\) x\_2\  + \ x\_1\^2\)]],
  ", which is not what the user wanted to see when asking for an expansion \
about ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  "."
}], "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["References", "Section",
  CellTags->"References"],

Cell[TextData[{
  "[ABR] Sheldon Axler, Paul Bourdon, and Wade Ramey, ",
  StyleBox["Harmonic Function Theory",
    FontSlant->"Italic"],
  ", second edition, Springer Graduate Texts in Mathematics, 2001."
}], "Text",
  CellTags->"ABR"],

Cell["\<\
[AGV] Sheldon Axler, Pamela Gorkin, and Karl Voss, The Dirichlet \
problem on quadratic surfaces, preprint, 2002.\
\>", "Text",
  CellTags->"AGV"],

Cell[TextData[{
  "[AR] Sheldon Axler and Wade Ramey, Harmonic polynomials and Dirichlet-type \
problems, ",
  StyleBox["Proceedings of the American Mathematical Society",
    FontSlant->"Italic"],
  " 123 (1995), 3765-3773."
}], "Text",
  CellTags->"AR"],

Cell["\<\
[R] Walter Rudin, Real and Complex Analysis, third edition, \
McGraw-Hill, 1987.\
\>", "Text",
  CellTags->"R"],

Cell[TextData[{
  "[W] Hermann Weyl, On the volume of tubes, ",
  StyleBox["American Journal of Mathematics",
    FontSlant->"Italic"],
  " 61 (1939), 461-472."
}], "Text",
  CellTags->"W"]
}, Closed]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1600}, {0, 1127}},
WindowToolbars->"EditBar",
CellGrouping->Manual,
WindowSize->{911, 1091},
WindowMargins->{{1, Automatic}, {Automatic, 0}},
IndexCreationOptions->{"Format"->"Hyperlinks"},
Magnification->1.25,
StyleDefinitions -> Notebook[{
  
  Cell[CellGroupData[{
  Cell["Style Definitions", "Subtitle"],
  
  Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell["Style Environment Names", "Section"],
  
  Cell[StyleData[All, "Working"],
    PageWidth->WindowWidth,
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Printout"],
    PageWidth->PaperWidth,
    ScriptMinSize->7,
    FontSize->10,
    PrivateFontOptions->{"FontType"->"Outline"}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Notebook Options", "Section"],
  
  Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],
  
  Cell[StyleData["Notebook"],
    PageHeaders->{{Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
            TextData[ {
              ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
            TextData[ {
              ValueBox[ "FileName"]}], "Header"], None, Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"]}},
    PrintingOptions->{"FirstPageHeader"->False,
    "FirstPageFace"->Right},
    StyleMenuListing->None,
    Background->RGBColor[0.900008, 0.863996, 0.809995]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Headings", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Title"],
    ShowCellBracket->False,
    CellMargins->{{0, 0}, {0, 0}},
    PageBreakBelow->False,
    TextAlignment->Center,
    LineSpacing->{1, 0},
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
    FontFamily->"Helvetica",
    FontSize->34,
    FontWeight->"Bold",
    FontColor->GrayLevel[1],
    Background->GrayLevel[0],
    FontVariations->{"Underline"->False,
    "Outline"->False,
    "Shadow"->False}],
  
  Cell[StyleData["Title", "Printout"],
    CellMargins->{{0, 0}, {0, 0}},
    TextAlignment->Center,
    FontSize->24,
    FontTracking->"Plain",
    Background->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subtitle"],
    ShowCellBracket->False,
    CellMargins->{{0, 0}, {0, 0}},
    PageBreakBelow->False,
    TextAlignment->Center,
    LineSpacing->{1, 3},
    ParagraphIndent->-96,
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
    FontFamily->"Helvetica",
    FontSize->18,
    FontColor->GrayLevel[1],
    Background->RGBColor[0.2, 0.700008, 0.700008]],
  
  Cell[StyleData["Subtitle", "Printout"],
    CellMargins->{{0, 0}, {0, 0}},
    TextAlignment->Center,
    ParagraphIndent->-85,
    FontSize->16,
    Background->GrayLevel[0.6]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubtitle"],
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {30, 10}},
    PageBreakBelow->False,
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
    FontFamily->"Helvetica",
    FontSize->14,
    FontSlant->"Italic"],
  
  Cell[StyleData["Subsubtitle", "Printout"],
    CellMargins->{{9, 10}, {50, 10}},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Section"],
    CellFrame->{{0, 0}, {0, 3}},
    CellDingbat->None,
    CellMargins->{{12, Inherited}, {4, 24}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CellFrameMargins->{{0, 4}, {6, 2}},
    CellFrameLabelMargins->2,
    TextAlignment->Center,
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->18,
    FontWeight->"Bold",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Section", "Printout"],
    CellFrame->{{0, 0}, {0, 3}},
    CellMargins->{{9, 0}, {2, 50}},
    TextAlignment->Center,
    FontSize->14,
    FontTracking->"Plain",
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsection"],
    CellFrame->{{0, 0}, {0, 2}},
    CellMargins->{{12, 10}, {0, 25}},
    LineSpacing->{1, 0},
    ParagraphSpacing->{0, 12},
    FontFamily->"Courier",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsection", "Printout"],
    CellFrame->{{0, 0}, {0, 2}},
    CellMargins->{{9, 0}, {4, 40}},
    FontFamily->"Courier",
    FontSize->16]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubsection"],
    CellFrame->{{0, 0}, {0, 2}},
    CellMargins->{{12, 10}, {5, 20}},
    CellFrameMargins->{{0, 0}, {0, 2}},
    CellFrameColor->GrayLevel[1],
    LineSpacing->{1, 0},
    ParagraphSpacing->{0, 12},
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0.4, 0, 0.6]],
  
  Cell[StyleData["Subsubsection", "Printout"],
    CellMargins->{{9, 0}, {4, 20}},
    FontSize->11]
  }, Closed]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Body Text", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Text"],
    CellDingbat->None,
    CellMargins->{{12, 10}, {5, 5}},
    TextAlignment->Left,
    TextJustification->0,
    LineSpacing->{1, 3},
    ParagraphSpacing->{0, 12},
    ParagraphIndent->0,
    FontFamily->"Times"],
  
  Cell[StyleData["Text", "Printout"],
    CellDingbat->None,
    CellMargins->{{111, 0}, {4, 4}},
    TextAlignment->Left,
    ParagraphSpacing->{0, 6},
    ParagraphIndent->0,
    FontSize->9]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Commentary"],
    CellMargins->{{52, 10}, {0, 10}},
    CellFrameMargins->{{0, 0}, {0, 2}},
    CellFrameColor->GrayLevel[1],
    LineSpacing->{1, 1},
    ParagraphSpacing->{0, 12},
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["Commentary", "Printout"],
    CellMargins->{{52, 0}, {2, 8}},
    LineSpacing->{1, 2},
    ParagraphSpacing->{0, 6},
    FontSize->8]
  }, Closed]]
  }, Open  ]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Input/Output", "Title"],
  
  Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.\
\>", "Title"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Input"],
    CellFrame->{{4, 4}, {0, 4}},
    CellMargins->{{52, 10}, {0, 2}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelMargins->{{21, Inherited}, {Inherited, Inherited}},
    CellFrameColor->RGBColor[0.8, 0.700008, 0.6],
    DefaultFormatType->DefaultInputFormatType,
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    FontFamily->"Courier",
    FontSize->14,
    FontWeight->"Bold",
    Background->GrayLevel[1]],
  
  Cell[StyleData["Input", "Printout"],
    FontSize->9,
    Background->GrayLevel[0.8]]
  }, Open  ]],
  
  Cell[StyleData["InlineInput"],
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    DefaultFormatType->DefaultInputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    CounterIncrements->"Input",
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Output"],
    CellFrame->{{4, 4}, {4, 0}},
    CellMargins->{{52, 10}, {12, 0}},
    CellEditDuplicate->True,
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    CellLabelMargins->{{21, Inherited}, {Inherited, Inherited}},
    CellFrameColor->RGBColor[0.8, 0.700008, 0.6],
    DefaultFormatType->DefaultOutputFormatType,
    FormatType->InputForm,
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Plain",
    FontTracking->"Plain",
    Background->GrayLevel[1],
    FontVariations->{"Underline"->False,
    "Outline"->False,
    "Shadow"->False}],
  
  Cell[StyleData["Output", "Printout"],
    FontSize->9,
    Background->GrayLevel[0.900008]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InputOnly"],
    CellFrame->4,
    CellMargins->{{52, 10}, {4, 2}},
    Evaluatable->True,
    CellGroupingRules->"NormalGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelMargins->{{21, Inherited}, {Inherited, Inherited}},
    CellFrameColor->RGBColor[0.8, 0.700008, 0.6],
    DefaultFormatType->DefaultInputFormatType,
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    FontFamily->"Courier",
    FontWeight->"Bold",
    Background->GrayLevel[1]],
  
  Cell[StyleData["InputOnly", "Printout"],
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OutputOnly"],
    CellFrame->4,
    CellMargins->{{52, 10}, {4, 2}},
    CellEditDuplicate->True,
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    CellLabelMargins->{{21, Inherited}, {Inherited, Inherited}},
    CellFrameColor->RGBColor[0.8, 0.700008, 0.6],
    DefaultFormatType->DefaultOutputFormatType,
    FormatType->InputForm,
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Plain",
    FontTracking->"Plain",
    Background->GrayLevel[1],
    FontVariations->{"Underline"->False,
    "Outline"->False,
    "Shadow"->False}],
  
  Cell[StyleData["OutputOnly", "Printout"],
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SymbolicExpression"],
    CellFrame->1,
    CellMargins->{{52, 10}, {4, 2}},
    CellEditDuplicate->True,
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    CellLabelMargins->{{21, Inherited}, {Inherited, Inherited}},
    CellFrameColor->GrayLevel[0],
    DefaultFormatType->DefaultOutputFormatType,
    FormatType->InputForm,
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Plain",
    FontTracking->"Plain",
    Background->GrayLevel[1],
    FontVariations->{"Underline"->False,
    "Outline"->False,
    "Shadow"->False}],
  
  Cell[StyleData["SymbolicExpression", "Printout"],
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Message"],
    CellMargins->{{60, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{21, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    FormatType->InputForm,
    StyleMenuListing->None,
    FontColor->RGBColor[1, 0, 0]],
  
  Cell[StyleData["Message", "Printout"],
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Print"],
    CellFrame->{{4, 4}, {4, 0}},
    CellMargins->{{52, 10}, {12, 0}},
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{21, Inherited}, {Inherited, Inherited}},
    CellFrameColor->RGBColor[0.8, 0.700008, 0.6],
    DefaultFormatType->DefaultOutputFormatType,
    FormatType->InputForm,
    StyleMenuListing->None,
    Background->GrayLevel[1]],
  
  Cell[StyleData["Print", "Printout"],
    FontSize->9]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Graphics"],
    CellFrame->{{4, 4}, {0, 0}},
    CellMargins->{{52, 10}, {0, 0}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellFrameColor->RGBColor[0.8, 0.700008, 0.6],
    DefaultFormatType->DefaultOutputFormatType,
    FormatType->InputForm,
    ImageMargins->{{43, Inherited}, {Inherited, 0}},
    StyleMenuListing->None,
    Background->GrayLevel[1]],
  
  Cell[StyleData["Graphics", "Printout"],
    ImageSize->{250, 250},
    ImageMargins->{{28, Inherited}, {Inherited, 0}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ImportPict"],
    CellMargins->{{52, 10}, {0, 0}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GeneratedCell->True,
    DefaultFormatType->DefaultOutputFormatType,
    FormatType->InputForm,
    StyleMenuListing->"ImportPict",
    Background->None],
  
  Cell[StyleData["ImportPict", "Printout"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CellLabel"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Plain",
    FontSlant->"Italic",
    FontColor->RGBColor[0.4, 0.4, 1]],
  
  Cell[StyleData["CellLabel", "Printout"],
    FontSize->7,
    FontSlant->"Italic",
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Unique Items", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PullQuote"],
    CellFrame->{{0, 0}, {0, 3}},
    CellMargins->{{0, 250}, {15, 5}},
    CellFrameMargins->{{20, 4}, {8, 6}},
    LineSpacing->{1, 1},
    ParagraphSpacing->{0, 12},
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold",
    FontColor->GrayLevel[1],
    Background->RGBColor[0.6, 0, 0.8]],
  
  Cell[StyleData["PullQuote", "Printout"],
    ParagraphSpacing->{0, 6},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GrayBox"],
    CellFrame->{{0, 0}, {0, 3}},
    CellMargins->{{62, 36}, {10, 5}},
    CellFrameMargins->{{8, 4}, {8, 4}},
    LineSpacing->{1, 3},
    ParagraphSpacing->{0, 12},
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Plain",
    FontColor->GrayLevel[0],
    Background->RGBColor[0.8, 0.700008, 0.6]],
  
  Cell[StyleData["GrayBox", "Printout"],
    CellMargins->{{62, 36}, {10, 5}},
    FontSize->9,
    Background->GrayLevel[0.8]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureGroup"],
    CellFrame->{{4, 4}, {0, 0}},
    CellMargins->{{52, Inherited}, {0, 0}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    ShowCellLabel->False,
    CellFrameColor->RGBColor[0.8, 0.700008, 0.6],
    ImageMargins->{{43, Inherited}, {Inherited, 0}},
    StyleMenuListing->None,
    Background->GrayLevel[1]],
  
  Cell[StyleData["PictureGroup", "Printout"],
    ImageSize->{250, 250},
    ImageMargins->{{28, Inherited}, {Inherited, 0}}]
  }, Closed]],
  
  Cell[StyleData["LineSpace"],
    CellMargins->{{0, 0}, {0, 0}},
    CellElementSpacings->{"CellMinHeight"->2},
    FontSize->9]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Headers and Footers", "Section"],
  
  Cell[StyleData["Header"],
    CellMargins->{{0, 0}, {4, 1}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontSlant->"Italic"],
  
  Cell[StyleData["Footer"],
    CellMargins->{{0, 0}, {0, 4}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->6],
  
  Cell[StyleData["PageNumber"],
    CellMargins->{{0, 0}, {4, 1}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontWeight->"Bold"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["FormatType Styles", "Section"],
  
  Cell["\<\
The cells below define styles that are mixed in with the styles \
of most cells.  If a cell's FormatType matches the name of one of the styles \
defined below, then that style is applied between the cell's style and its \
own options.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CellExpression"],
    CellFrame->1,
    CellMargins->{{52, 10}, {4, 2}},
    ShowCellLabel->False,
    CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
    ShowSpecialCharacters->False,
    AllowInlineCells->False,
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->10,
    FontColor->GrayLevel[0],
    Background->GrayLevel[1]],
  
  Cell[BoxData[""], "Input"]
  }, Open  ]]
  }, Open  ]]
  }, Open  ]]
  }]
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Getting Started"->{
    Cell[1957, 60, 65, 1, 70, "Section",
      CellTags->"Getting Started"]},
  "Loading the Package"->{
    Cell[2047, 65, 81, 1, 66, "Subsection",
      CellTags->"Loading the Package"],
    Cell[4352, 132, 76, 1, 66, "Subsection",
      CellTags->"Loading the Package"]},
  "On-line Help"->{
    Cell[6332, 190, 62, 1, 66, "Subsection",
      CellTags->"On-line Help"]},
  "Info3269422509-9203424"->{
    Cell[6723, 205, 157, 3, 60, "Print",
      CellTags->"Info3269422509-9203424"]},
  "Calculus in R^n"->{
    Cell[8072, 243, 216, 8, 44, "Section",
      CellTags->"Calculus in R^n"]},
  "Norm"->{
    Cell[8313, 255, 46, 1, 66, "Subsection",
      CellTags->"Norm"]},
  "ExpandNorm"->{
    Cell[9459, 297, 58, 1, 66, "Subsection",
      CellTags->"ExpandNorm"]},
  "Partial"->{
    Cell[12589, 400, 52, 1, 66, "Subsection",
      CellTags->"Partial"]},
  "Laplacian"->{
    Cell[15972, 517, 56, 1, 66, "Subsection",
      CellTags->"Laplacian"]},
  "Grad"->{
    Cell[24331, 825, 46, 1, 66, "Subsection",
      CellTags->"Grad"]},
  "Delta"->{
    Cell[25298, 864, 255, 8, 33, "Text",
      CellTags->"Delta"]},
  "NormalD"->{
    Cell[25590, 877, 52, 1, 66, "Subsection",
      CellTags->"NormalD"]},
  "Matrices"->{
    Cell[30014, 1014, 54, 1, 66, "Subsection",
      CellTags->"Matrices"]},
  "Divergence"->{
    Cell[37222, 1278, 58, 1, 66, "Subsection",
      CellTags->"Divergence"]},
  "J"->{
    Cell[38249, 1323, 40, 1, 66, "Subsection",
      CellTags->"J"]},
  "Homogeneous"->{
    Cell[41334, 1439, 60, 1, 66, "Subsection",
      CellTags->"Homogeneous"]},
  "Taylor"->{
    Cell[43855, 1535, 50, 1, 66, "Subsection",
      CellTags->"Taylor"]},
  "Nonexplicit Functions"->{
    Cell[46444, 1633, 80, 1, 66, "Subsection",
      CellTags->"Nonexplicit Functions"]},
  "Vector-valued Functions"->{
    Cell[50463, 1771, 84, 1, 66, "Subsection",
      CellTags->"Vector-valued Functions"]},
  "Volume"->{
    Cell[53482, 1880, 50, 1, 66, "Subsection",
      CellTags->"Volume"]},
  "SurfaceArea"->{
    Cell[54267, 1918, 60, 1, 66, "Subsection",
      CellTags->"SurfaceArea"]},
  "IntegrateSphere"->{
    Cell[55250, 1962, 68, 1, 66, "Subsection",
      CellTags->"IntegrateSphere"]},
  "IntegrateBall"->{
    Cell[56534, 2016, 64, 1, 66, "Subsection",
      CellTags->"IntegrateBall"]},
  "Boundary Value Problems"->{
    Cell[58313, 2088, 81, 1, 44, "Section",
      CellTags->"Boundary Value Problems"]},
  "Dirichlet"->{
    Cell[58419, 2093, 65, 1, 66, "Subsection",
      CellTags->"Dirichlet"]},
  "HarmonicDecomposition"->{
    Cell[83474, 2946, 80, 1, 39, "Subsection",
      CellTags->"HarmonicDecomposition"]},
  "AntiLaplacian"->{
    Cell[88531, 3117, 64, 1, 39, "Subsection",
      CellTags->"AntiLaplacian"]},
  "Neumann"->{
    Cell[103060, 3560, 52, 1, 39, "Subsection",
      CellTags->"Neumann"]},
  "ExteriorNeumann"->{
    Cell[104994, 3618, 68, 1, 39, "Subsection",
      CellTags->"ExteriorNeumann"]},
  "BiDirichlet"->{
    Cell[107138, 3679, 60, 1, 39, "Subsection",
      CellTags->"BiDirichlet"]},
  "Spherical Harmonics"->{
    Cell[110563, 3792, 73, 1, 44, "Section",
      CellTags->"Spherical Harmonics"]},
  "BasisH"->{
    Cell[110661, 3797, 50, 1, 66, "Subsection",
      CellTags->"BasisH"]},
  "ZonalHarmonic"->{
    Cell[141325, 4804, 64, 1, 39, "Subsection",
      CellTags->"ZonalHarmonic"]},
  "DimensionH"->{
    Cell[145269, 4945, 58, 1, 39, "Subsection",
      CellTags->"DimensionH"]},
  "Inversion and the Kelvin Transform"->{
    Cell[146348, 4993, 103, 1, 44, "Section",
      CellTags->"Inversion and the Kelvin Transform"]},
  "Inversion"->{
    Cell[146476, 4998, 57, 1, 66, "Subsection",
      CellTags->"Inversion"]},
  "Kelvin"->{
    Cell[150706, 5162, 50, 1, 66, "Subsection",
      CellTags->"Kelvin"]},
  "Phi"->{
    Cell[151616, 5201, 44, 1, 66, "Subsection",
      CellTags->"Phi"]},
  "KelvinM"->{
    Cell[155671, 5359, 52, 1, 66, "Subsection",
      CellTags->"KelvinM"]},
  "Kernels"->{
    Cell[160379, 5537, 49, 1, 44, "Section",
      CellTags->"Kernels"]},
  "PoissonKernel"->{
    Cell[160453, 5542, 64, 1, 66, "Subsection",
      CellTags->"PoissonKernel"]},
  "PoisssonKernelH"->{
    Cell[162360, 5616, 67, 1, 66, "Subsection",
      CellTags->"PoisssonKernelH"]},
  "BergmanKernel"->{
    Cell[167111, 5815, 64, 1, 66, "Subsection",
      CellTags->"BergmanKernel"]},
  "BergmanKernelH"->{
    Cell[168410, 5862, 66, 1, 66, "Subsection",
      CellTags->"BergmanKernelH"]},
  "Miscellaneous"->{
    Cell[171523, 5982, 61, 1, 44, "Section",
      CellTags->"Miscellaneous"]},
  "BergmanProjection"->{
    Cell[171609, 5987, 72, 1, 66, "Subsection",
      CellTags->"BergmanProjection"]},
  "HarmonicConjugate"->{
    Cell[173810, 6059, 72, 1, 66, "Subsection",
      CellTags->"HarmonicConjugate"]},
  "Schwarz"->{
    Cell[175281, 6122, 52, 1, 66, "Subsection",
      CellTags->"Schwarz"]},
  "TurnOff and TurnOn"->{
    Cell[177673, 6202, 68, 1, 66, "Subsection",
      CellTags->"TurnOff and TurnOn"]},
  "References"->{
    Cell[180844, 6297, 55, 1, 44, "Section",
      CellTags->"References"]},
  "ABR"->{
    Cell[180902, 6300, 236, 6, 54, "Text",
      CellTags->"ABR"]},
  "AGV"->{
    Cell[181141, 6308, 156, 4, 33, "Text",
      CellTags->"AGV"]},
  "AR"->{
    Cell[181300, 6314, 255, 7, 54, "Text",
      CellTags->"AR"]},
  "R"->{
    Cell[181558, 6323, 121, 4, 33, "Text",
      CellTags->"R"]},
  "W"->{
    Cell[181682, 6329, 189, 6, 33, "Text",
      CellTags->"W"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Getting Started", 199232, 6978},
  {"Loading the Package", 199337, 6981},
  {"On-line Help", 199527, 6986},
  {"Info3269422509-9203424", 199636, 6989},
  {"Calculus in R^n", 199744, 6992},
  {"Norm", 199836, 6995},
  {"ExpandNorm", 199925, 6998},
  {"Partial", 200017, 7001},
  {"Laplacian", 200109, 7004},
  {"Grad", 200198, 7007},
  {"Delta", 200283, 7010},
  {"NormalD", 200366, 7013},
  {"Matrices", 200457, 7016},
  {"Divergence", 200552, 7019},
  {"J", 200640, 7022},
  {"Homogeneous", 200729, 7025},
  {"Taylor", 200823, 7028},
  {"Nonexplicit Functions", 200927, 7031},
  {"Vector-valued Functions", 201048, 7034},
  {"Volume", 201154, 7037},
  {"SurfaceArea", 201248, 7040},
  {"IntegrateSphere", 201351, 7043},
  {"IntegrateBall", 201456, 7046},
  {"Boundary Value Problems", 201569, 7049},
  {"Dirichlet", 201675, 7052},
  {"HarmonicDecomposition", 201782, 7055},
  {"AntiLaplacian", 201893, 7058},
  {"Neumann", 201990, 7061},
  {"ExteriorNeumann", 202090, 7064},
  {"BiDirichlet", 202194, 7067},
  {"Spherical Harmonics", 202302, 7070},
  {"BasisH", 202402, 7073},
  {"ZonalHarmonic", 202499, 7076},
  {"DimensionH", 202600, 7079},
  {"Inversion and the Kelvin Transform", 202722, 7082},
  {"Inversion", 202841, 7085},
  {"Kelvin", 202934, 7088},
  {"Phi", 203021, 7091},
  {"KelvinM", 203109, 7094},
  {"Kernels", 203201, 7097},
  {"PoissonKernel", 203296, 7100},
  {"PoisssonKernelH", 203402, 7103},
  {"BergmanKernel", 203508, 7106},
  {"BergmanKernelH", 203613, 7109},
  {"Miscellaneous", 203718, 7112},
  {"BergmanProjection", 203823, 7115},
  {"HarmonicConjugate", 203935, 7118},
  {"Schwarz", 204037, 7121},
  {"TurnOff and TurnOn", 204140, 7124},
  {"References", 204246, 7127},
  {"ABR", 204334, 7130},
  {"AGV", 204413, 7133},
  {"AR", 204491, 7136},
  {"R", 204567, 7139},
  {"W", 204642, 7142}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 50, 0, 71, "Title"],
Cell[1807, 53, 33, 0, 50, "Subtitle"],
Cell[1843, 55, 89, 1, 33, "Text"],

Cell[CellGroupData[{
Cell[1957, 60, 65, 1, 70, "Section",
  CellTags->"Getting Started"],

Cell[CellGroupData[{
Cell[2047, 65, 81, 1, 66, "Subsection",
  CellTags->"Loading the Package"],
Cell[2131, 68, 404, 8, 75, "Text"],
Cell[2538, 78, 747, 17, 96, "Text"],
Cell[3288, 97, 258, 8, 33, "Text"],
Cell[3549, 107, 473, 11, 54, "Text"],
Cell[4025, 120, 290, 7, 54, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[4352, 132, 76, 1, 66, "Subsection",
  CellTags->"Loading the Package"],
Cell[4431, 135, 479, 9, 75, "Text"],

Cell[CellGroupData[{
Cell[4935, 148, 88, 1, 51, "Input"],
Cell[5026, 151, 67, 1, 60, "Print"],
Cell[5096, 154, 277, 4, 102, "Print"],
Cell[5376, 160, 199, 3, 81, "Print"],
Cell[5578, 165, 273, 4, 102, "Print"],
Cell[5854, 171, 128, 2, 81, "Print"],
Cell[5985, 175, 85, 1, 60, "Print"],
Cell[6073, 178, 83, 1, 60, "Print"]
}, Closed]],
Cell[6171, 182, 124, 3, 33, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[6332, 190, 62, 1, 66, "Subsection",
  CellTags->"On-line Help"],
Cell[6397, 193, 254, 5, 54, "Text"],

Cell[CellGroupData[{
Cell[6676, 202, 44, 1, 51, "Input"],
Cell[6723, 205, 157, 3, 60, "Print",
  CellTags->"Info3269422509-9203424"]
}, Closed]],
Cell[6895, 211, 187, 6, 33, "Text"],

Cell[CellGroupData[{
Cell[7107, 221, 51, 1, 51, "Input"],
Cell[7161, 224, 850, 12, 207, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8072, 243, 216, 8, 44, "Section",
  CellTags->"Calculus in R^n"],

Cell[CellGroupData[{
Cell[8313, 255, 46, 1, 66, "Subsection",
  CellTags->"Norm"],
Cell[8362, 258, 742, 22, 87, "Text"],

Cell[CellGroupData[{
Cell[9129, 284, 115, 2, 51, "Input"],
Cell[9247, 288, 163, 3, 60, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[9459, 297, 58, 1, 66, "Subsection",
  CellTags->"ExpandNorm"],
Cell[9520, 300, 783, 23, 62, "Text"],
Cell[10306, 325, 427, 7, 54, "Text"],
Cell[10736, 334, 464, 16, 33, "Text"],

Cell[CellGroupData[{
Cell[11225, 354, 386, 6, 74, "Input"],
Cell[11614, 362, 407, 7, 74, "Output"]
}, Closed]],
Cell[12036, 372, 297, 9, 58, "Text"],

Cell[CellGroupData[{
Cell[12358, 385, 46, 1, 51, "Input"],
Cell[12407, 388, 35, 1, 60, "Output"]
}, Closed]],
Cell[12457, 392, 95, 3, 33, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[12589, 400, 52, 1, 66, "Subsection",
  CellTags->"Partial"],
Cell[12644, 403, 1251, 46, 87, "Text"],

Cell[CellGroupData[{
Cell[13920, 453, 119, 2, 51, "Input"],
Cell[14042, 457, 320, 6, 60, "Output"]
}, Closed]],
Cell[14377, 466, 410, 13, 58, "Text"],
Cell[14790, 481, 534, 14, 79, "Text"],

Cell[CellGroupData[{
Cell[15349, 499, 131, 2, 51, "Input"],
Cell[15483, 503, 440, 8, 80, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[15972, 517, 56, 1, 66, "Subsection",
  CellTags->"Laplacian"],
Cell[16031, 520, 225, 9, 37, "Text"],

Cell[CellGroupData[{
Cell[16281, 533, 114, 2, 51, "Input"],
Cell[16398, 537, 121, 2, 78, "Output"]
}, Closed]],
Cell[16534, 542, 1237, 43, 100, "Text"],

Cell[CellGroupData[{
Cell[17796, 589, 51, 1, 51, "Input"],
Cell[17850, 592, 171, 3, 51, "Message"]
}, Closed]],

Cell[CellGroupData[{
Cell[18058, 600, 185, 3, 51, "Input"],
Cell[18246, 605, 783, 14, 81, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[19066, 624, 71, 1, 51, "Input"],
Cell[19140, 627, 35, 1, 60, "Output"]
}, Closed]],
Cell[19190, 631, 324, 14, 33, "Text"],
Cell[19517, 647, 695, 23, 55, "Text"],

Cell[CellGroupData[{
Cell[20237, 674, 117, 2, 51, "Input"],
Cell[20357, 678, 124, 2, 80, "Output"]
}, Closed]],
Cell[20496, 683, 2249, 81, 146, "Text"],

Cell[CellGroupData[{
Cell[22770, 768, 55, 1, 51, "Input"],
Cell[22828, 771, 184, 3, 51, "Message"]
}, Closed]],

Cell[CellGroupData[{
Cell[23049, 779, 144, 3, 55, "Input"],
Cell[23196, 784, 634, 10, 86, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[23867, 799, 46, 1, 51, "Input"],
Cell[23916, 802, 35, 1, 60, "Output"]
}, Closed]],
Cell[23966, 806, 328, 14, 33, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[24331, 825, 46, 1, 66, "Subsection",
  CellTags->"Grad"],
Cell[24380, 828, 637, 22, 62, "Text"],

Cell[CellGroupData[{
Cell[25042, 854, 125, 3, 51, "Input"],
Cell[25170, 859, 113, 2, 74, "Output"]
}, Closed]],
Cell[25298, 864, 255, 8, 33, "Text",
  CellTags->"Delta"]
}, Closed]],

Cell[CellGroupData[{
Cell[25590, 877, 52, 1, 66, "Subsection",
  CellTags->"NormalD"],
Cell[25645, 880, 257, 9, 37, "Text"],
Cell[25905, 891, 584, 21, 54, "Text"],
Cell[26492, 914, 376, 6, 56, "Text"],
Cell[26871, 922, 251, 5, 54, "Text"],

Cell[CellGroupData[{
Cell[27147, 931, 338, 5, 76, "Input"],
Cell[27488, 938, 445, 7, 84, "Output"]
}, Closed]],
Cell[27948, 948, 613, 16, 61, "Text"],

Cell[CellGroupData[{
Cell[28586, 968, 311, 5, 74, "Input"],
Cell[28900, 975, 458, 7, 85, "Output"]
}, Closed]],
Cell[29373, 985, 206, 7, 37, "Text"],

Cell[CellGroupData[{
Cell[29604, 996, 47, 1, 51, "Input"],
Cell[29654, 999, 190, 4, 60, "Output"]
}, Closed]],
Cell[29859, 1006, 118, 3, 33, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[30014, 1014, 54, 1, 66, "Subsection",
  CellTags->"Matrices"],

Cell[CellGroupData[{
Cell[30093, 1019, 42, 0, 53, "Subsubsection"],
Cell[30138, 1021, 906, 29, 108, "Text"],

Cell[CellGroupData[{
Cell[31069, 1054, 58, 1, 51, "Input"],
Cell[31130, 1057, 154, 3, 30, "Message"]
}, Closed]],

Cell[CellGroupData[{
Cell[31321, 1065, 107, 2, 51, "Input"],
Cell[31431, 1069, 111, 2, 77, "Output"]
}, Closed]],
Cell[31557, 1074, 1993, 68, 138, "Text"],
Cell[33553, 1144, 705, 18, 104, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[34295, 1167, 41, 0, 53, "Subsubsection"],
Cell[34339, 1169, 528, 23, 33, "Text"],

Cell[CellGroupData[{
Cell[34892, 1196, 185, 3, 51, "Input"],
Cell[35080, 1201, 222, 3, 78, "Output"]
}, Closed]],
Cell[35317, 1207, 791, 24, 75, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[36145, 1236, 39, 0, 53, "Subsubsection"],
Cell[36187, 1238, 301, 9, 58, "Text"],

Cell[CellGroupData[{
Cell[36513, 1251, 112, 2, 51, "Input"],
Cell[36628, 1255, 269, 4, 80, "Output"]
}, Closed]],
Cell[36912, 1262, 261, 10, 33, "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[37222, 1278, 58, 1, 66, "Subsection",
  CellTags->"Divergence"],
Cell[37283, 1281, 238, 9, 37, "Text"],

Cell[CellGroupData[{
Cell[37546, 1294, 58, 1, 51, "Input"],
Cell[37607, 1297, 154, 3, 30, "Message"]
}, Closed]],

Cell[CellGroupData[{
Cell[37798, 1305, 122, 3, 51, "Input"],
Cell[37923, 1310, 211, 5, 77, "Output"]
}, Closed]],
Cell[38149, 1318, 63, 0, 33, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[38249, 1323, 40, 1, 66, "Subsection",
  CellTags->"J"],
Cell[38292, 1326, 971, 32, 104, "Text"],

Cell[CellGroupData[{
Cell[39288, 1362, 51, 1, 51, "Input"],
Cell[39342, 1365, 171, 3, 51, "Message"]
}, Closed]],

Cell[CellGroupData[{
Cell[39550, 1373, 105, 2, 51, "Input"],
Cell[39658, 1377, 219, 4, 78, "Output"]
}, Closed]],
Cell[39892, 1384, 1111, 39, 104, "Text"],
Cell[41006, 1425, 291, 9, 33, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[41334, 1439, 60, 1, 66, "Subsection",
  CellTags->"Homogeneous"],
Cell[41397, 1442, 420, 15, 58, "Text"],

Cell[CellGroupData[{
Cell[41842, 1461, 51, 1, 51, "Input"],
Cell[41896, 1464, 171, 3, 51, "Message"]
}, Closed]],

Cell[CellGroupData[{
Cell[42104, 1472, 159, 3, 77, "Input"],
Cell[42266, 1477, 120, 2, 74, "Output"]
}, Closed]],
Cell[42401, 1482, 473, 16, 58, "Text"],

Cell[CellGroupData[{
Cell[42899, 1502, 75, 1, 51, "Input"],
Cell[42977, 1505, 173, 3, 51, "Message"],
Cell[43153, 1510, 127, 2, 60, "Output"]
}, Closed]],
Cell[43295, 1515, 523, 15, 79, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[43855, 1535, 50, 1, 66, "Subsection",
  CellTags->"Taylor"],
Cell[43908, 1538, 437, 15, 58, "Text"],

Cell[CellGroupData[{
Cell[44370, 1557, 100, 2, 77, "Input"],
Cell[44473, 1561, 127, 2, 77, "Output"]
}, Closed]],
Cell[44615, 1566, 494, 17, 58, "Text"],

Cell[CellGroupData[{
Cell[45134, 1587, 74, 1, 51, "Input"],
Cell[45211, 1590, 253, 5, 60, "Output"]
}, Closed]],
Cell[45479, 1598, 662, 19, 79, "Text"],

Cell[CellGroupData[{
Cell[46166, 1621, 53, 1, 51, "Input"],
Cell[46222, 1624, 173, 3, 51, "Message"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[46444, 1633, 80, 1, 66, "Subsection",
  CellTags->"Nonexplicit Functions"],
Cell[46527, 1636, 424, 11, 54, "Text"],

Cell[CellGroupData[{
Cell[46976, 1651, 55, 1, 51, "Input"],
Cell[47034, 1654, 214, 4, 60, "Output"]
}, Closed]],
Cell[47263, 1661, 707, 26, 76, "Text"],

Cell[CellGroupData[{
Cell[47995, 1691, 60, 1, 51, "Input"],
Cell[48058, 1694, 637, 15, 81, "Output"]
}, Closed]],
Cell[48710, 1712, 244, 9, 37, "Text"],
Cell[48957, 1723, 1469, 43, 154, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[50463, 1771, 84, 1, 66, "Subsection",
  CellTags->"Vector-valued Functions"],
Cell[50550, 1774, 314, 11, 33, "Text"],

Cell[CellGroupData[{
Cell[50889, 1789, 61, 1, 51, "Input"],
Cell[50953, 1792, 345, 8, 61, "Output"]
}, Closed]],
Cell[51313, 1803, 968, 29, 88, "Text"],

Cell[CellGroupData[{
Cell[52306, 1836, 87, 2, 51, "Input"],
Cell[52396, 1840, 196, 3, 51, "Message"]
}, Closed]],

Cell[CellGroupData[{
Cell[52629, 1848, 61, 1, 51, "Input"],
Cell[52693, 1851, 277, 6, 61, "Output"]
}, Closed]],
Cell[52985, 1860, 460, 15, 64, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[53482, 1880, 50, 1, 66, "Subsection",
  CellTags->"Volume"],
Cell[53535, 1883, 346, 12, 37, "Text"],

Cell[CellGroupData[{
Cell[53906, 1899, 42, 1, 51, "Input"],
Cell[53951, 1902, 45, 1, 77, "Output"]
}, Closed]],
Cell[54011, 1906, 219, 7, 37, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[54267, 1918, 60, 1, 66, "Subsection",
  CellTags->"SurfaceArea"],
Cell[54330, 1921, 359, 12, 37, "Text"],

Cell[CellGroupData[{
Cell[54714, 1937, 48, 1, 51, "Input"],
Cell[54765, 1940, 99, 2, 77, "Output"]
}, Closed]],
Cell[54879, 1945, 334, 12, 37, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[55250, 1962, 68, 1, 66, "Subsection",
  CellTags->"IntegrateSphere"],
Cell[55321, 1965, 476, 16, 58, "Text"],

Cell[CellGroupData[{
Cell[55822, 1985, 51, 1, 51, "Input"],
Cell[55876, 1988, 171, 3, 51, "Message"]
}, Closed]],

Cell[CellGroupData[{
Cell[56084, 1996, 78, 1, 51, "Input"],
Cell[56165, 1999, 111, 2, 77, "Output"]
}, Closed]],
Cell[56291, 2004, 206, 7, 37, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[56534, 2016, 64, 1, 66, "Subsection",
  CellTags->"IntegrateBall"],
Cell[56601, 2019, 807, 28, 79, "Text"],

Cell[CellGroupData[{
Cell[57433, 2051, 51, 1, 51, "Input"],
Cell[57487, 2054, 171, 3, 51, "Message"]
}, Closed]],

Cell[CellGroupData[{
Cell[57695, 2062, 141, 3, 51, "Input"],
Cell[57839, 2067, 96, 2, 83, "Output"]
}, Closed]],
Cell[57950, 2072, 314, 10, 58, "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[58313, 2088, 81, 1, 44, "Section",
  CellTags->"Boundary Value Problems"],

Cell[CellGroupData[{
Cell[58419, 2093, 65, 1, 66, "Subsection",
  CellTags->"Dirichlet"],

Cell[CellGroupData[{
Cell[58509, 2098, 60, 0, 53, "Subsubsection"],
Cell[58572, 2100, 715, 24, 83, "Text"],

Cell[CellGroupData[{
Cell[59312, 2128, 51, 1, 51, "Input"],
Cell[59366, 2131, 171, 3, 51, "Message"]
}, Closed]],

Cell[CellGroupData[{
Cell[59574, 2139, 63, 1, 51, "Input"],
Cell[59640, 2142, 899, 16, 96, "Output"]
}, Closed]],
Cell[60554, 2161, 476, 13, 54, "Text"],

Cell[CellGroupData[{
Cell[61055, 2178, 50, 1, 51, "Input"],
Cell[61108, 2181, 35, 1, 60, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[61180, 2187, 109, 2, 51, "Input"],
Cell[61292, 2191, 50, 1, 60, "Output"]
}, Closed]],
Cell[61357, 2195, 75, 0, 33, "Text"],
Cell[61435, 2197, 214, 7, 33, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[61686, 2209, 76, 0, 53, "Subsubsection"],
Cell[61765, 2211, 702, 23, 87, "Text"],
Cell[62470, 2236, 884, 28, 76, "Text"],

Cell[CellGroupData[{
Cell[63379, 2268, 103, 2, 51, "Input"],
Cell[63485, 2272, 1273, 20, 121, "Output"]
}, Closed]],
Cell[64773, 2295, 756, 23, 83, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[65566, 2323, 65, 0, 53, "Subsubsection"],
Cell[65634, 2325, 884, 33, 76, "Text"],

Cell[CellGroupData[{
Cell[66543, 2362, 104, 2, 51, "Input"],
Cell[66650, 2366, 694, 10, 148, "Output"]
}, Closed]],
Cell[67359, 2379, 571, 18, 54, "Text"],

Cell[CellGroupData[{
Cell[67955, 2401, 50, 1, 51, "Input"],
Cell[68008, 2404, 35, 1, 60, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[68080, 2410, 109, 2, 51, "Input"],
Cell[68192, 2414, 41, 1, 60, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[68270, 2420, 110, 2, 51, "Input"],
Cell[68383, 2424, 41, 1, 60, "Output"]
}, Closed]],
Cell[68439, 2428, 348, 12, 56, "Text"],
Cell[68790, 2442, 231, 7, 33, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[69058, 2454, 68, 0, 53, "Subsubsection"],
Cell[69129, 2456, 260, 8, 55, "Text"],
Cell[69392, 2466, 124, 2, 30, "Text"],
Cell[69519, 2470, 588, 20, 54, "Text"],
Cell[70110, 2492, 140, 3, 30, "Text"],
Cell[70253, 2497, 212, 9, 33, "Text"],

Cell[CellGroupData[{
Cell[70490, 2510, 51, 1, 51, "Input"],
Cell[70544, 2513, 171, 3, 51, "Message"]
}, Closed]],

Cell[CellGroupData[{
Cell[70752, 2521, 134, 2, 51, "Input"],
Cell[70889, 2525, 217, 3, 77, "Output"]
}, Closed]],
Cell[71121, 2531, 620, 16, 75, "Text"],

Cell[CellGroupData[{
Cell[71766, 2551, 50, 1, 51, "Input"],
Cell[71819, 2554, 35, 1, 60, "Output"]
}, Closed]],
Cell[71869, 2558, 738, 21, 75, "Text"],
Cell[72610, 2581, 139, 5, 33, "Text"],
Cell[72752, 2588, 219, 6, 33, "Text"],
Cell[72974, 2596, 430, 12, 54, "Text"],

Cell[CellGroupData[{
Cell[73429, 2612, 118, 2, 51, "Input"],
Cell[73550, 2616, 458, 7, 117, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[74057, 2629, 55, 0, 53, "Subsubsection"],
Cell[74115, 2631, 1099, 32, 100, "Text"],

Cell[CellGroupData[{
Cell[75239, 2667, 115, 2, 51, "Input"],
Cell[75357, 2671, 748, 13, 96, "Output"]
}, Closed]],
Cell[76120, 2687, 393, 9, 54, "Text"],

Cell[CellGroupData[{
Cell[76538, 2700, 50, 1, 51, "Input"],
Cell[76591, 2703, 47, 1, 60, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[76675, 2709, 109, 2, 51, "Input"],
Cell[76787, 2713, 50, 1, 60, "Output"]
}, Closed]],
Cell[76852, 2717, 843, 25, 79, "Text"],

Cell[CellGroupData[{
Cell[77720, 2746, 145, 2, 51, "Input"],
Cell[77868, 2750, 462, 7, 117, "Output"]
}, Closed]],
Cell[78345, 2760, 512, 14, 54, "Text"],

Cell[CellGroupData[{
Cell[78882, 2778, 50, 1, 51, "Input"],
Cell[78935, 2781, 41, 1, 60, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[79025, 2788, 69, 0, 53, "Subsubsection"],
Cell[79097, 2790, 1195, 42, 75, "Text"],

Cell[CellGroupData[{
Cell[80317, 2836, 73, 1, 51, "Input"],
Cell[80393, 2839, 223, 3, 96, "Output"]
}, Closed]],
Cell[80631, 2845, 141, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[80797, 2852, 58, 1, 51, "Input"],
Cell[80858, 2855, 35, 1, 60, "Output"]
}, Closed]],
Cell[80908, 2859, 324, 7, 54, "Text"],

Cell[CellGroupData[{
Cell[81257, 2870, 102, 2, 57, "Input"],
Cell[81362, 2874, 35, 1, 60, "Output"]
}, Closed]],
Cell[81412, 2878, 673, 22, 54, "Text"],

Cell[CellGroupData[{
Cell[82110, 2904, 169, 3, 77, "Input"],
Cell[82282, 2909, 598, 8, 187, "Output"]
}, Closed]],
Cell[82895, 2920, 388, 11, 33, "Text"],

Cell[CellGroupData[{
Cell[83308, 2935, 58, 1, 51, "Input"],
Cell[83369, 2938, 44, 1, 60, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[83474, 2946, 80, 1, 39, "Subsection",
  CellTags->"HarmonicDecomposition"],
Cell[83557, 2949, 524, 18, 58, "Text"],

Cell[CellGroupData[{
Cell[84106, 2971, 51, 1, 51, "Input"],
Cell[84160, 2974, 171, 3, 51, "Message"]
}, Closed]],

Cell[CellGroupData[{
Cell[84368, 2982, 66, 1, 51, "Input"],
Cell[84437, 2985, 383, 6, 80, "Output"]
}, Closed]],
Cell[84835, 2994, 1697, 52, 96, "Text"],
Cell[86535, 3048, 1550, 49, 50, "Text"],
Cell[88088, 3099, 406, 13, 58, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[88531, 3117, 64, 1, 39, "Subsection",
  CellTags->"AntiLaplacian"],
Cell[88598, 3120, 742, 27, 58, "Text"],

Cell[CellGroupData[{
Cell[89365, 3151, 51, 1, 51, "Input"],
Cell[89419, 3154, 171, 3, 51, "Message"]
}, Closed]],

Cell[CellGroupData[{
Cell[89627, 3162, 214, 5, 77, "Input"],
Cell[89844, 3169, 561, 8, 77, "Output"]
}, Closed]],
Cell[90420, 3180, 501, 14, 33, "Text"],

Cell[CellGroupData[{
Cell[90946, 3198, 50, 1, 51, "Input"],
Cell[90999, 3201, 171, 3, 60, "Output"]
}, Closed]],
Cell[91185, 3207, 2490, 103, 125, "Text"],
Cell[93678, 3312, 1021, 32, 43, "Text"],
Cell[94702, 3346, 536, 19, 54, "Text"],
Cell[95241, 3367, 283, 7, 41, "Text"],
Cell[95527, 3376, 55, 0, 33, "Text"],
Cell[95585, 3378, 259, 5, 49, "Text"],
Cell[95847, 3385, 730, 20, 141, "Text"],

Cell[CellGroupData[{
Cell[96602, 3409, 159, 4, 51, "Input"],
Cell[96764, 3415, 2296, 45, 262, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[99097, 3465, 186, 4, 51, "Input"],
Cell[99286, 3471, 2298, 45, 262, "Output"]
}, Closed]],
Cell[101599, 3519, 761, 21, 79, "Text"],

Cell[CellGroupData[{
Cell[102385, 3544, 93, 1, 51, "Input"],
Cell[102481, 3547, 530, 7, 77, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[103060, 3560, 52, 1, 39, "Subsection",
  CellTags->"Neumann"],
Cell[103115, 3563, 845, 21, 100, "Text"],

Cell[CellGroupData[{
Cell[103985, 3588, 51, 1, 51, "Input"],
Cell[104039, 3591, 171, 3, 51, "Message"]
}, Closed]],

Cell[CellGroupData[{
Cell[104247, 3599, 77, 2, 77, "Input"],
Cell[104327, 3603, 618, 9, 115, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[104994, 3618, 68, 1, 39, "Subsection",
  CellTags->"ExteriorNeumann"],
Cell[105065, 3621, 797, 21, 100, "Text"],

Cell[CellGroupData[{
Cell[105887, 3646, 51, 1, 51, "Input"],
Cell[105941, 3649, 171, 3, 51, "Message"]
}, Closed]],

Cell[CellGroupData[{
Cell[106149, 3657, 66, 1, 51, "Input"],
Cell[106218, 3660, 871, 13, 132, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[107138, 3679, 60, 1, 39, "Subsection",
  CellTags->"BiDirichlet"],
Cell[107201, 3682, 646, 18, 79, "Text"],

Cell[CellGroupData[{
Cell[107872, 3704, 51, 1, 51, "Input"],
Cell[107926, 3707, 171, 3, 51, "Message"]
}, Closed]],

Cell[CellGroupData[{
Cell[108134, 3715, 65, 1, 53, "Input"],
Cell[108202, 3718, 1502, 27, 138, "Output"]
}, Closed]],
Cell[109719, 3748, 148, 3, 31, "Text"],

Cell[CellGroupData[{
Cell[109892, 3755, 57, 1, 51, "Input"],
Cell[109952, 3758, 35, 1, 60, "Output"]
}, Closed]],
Cell[110002, 3762, 110, 3, 31, "Text"],

Cell[CellGroupData[{
Cell[110137, 3769, 49, 1, 51, "Input"],
Cell[110189, 3772, 35, 1, 60, "Output"]
}, Closed]],
Cell[110239, 3776, 75, 0, 31, "Text"],

Cell[CellGroupData[{
Cell[110339, 3780, 110, 2, 51, "Input"],
Cell[110452, 3784, 50, 1, 60, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[110563, 3792, 73, 1, 44, "Section",
  CellTags->"Spherical Harmonics"],

Cell[CellGroupData[{
Cell[110661, 3797, 50, 1, 66, "Subsection",
  CellTags->"BasisH"],
Cell[110714, 3800, 1152, 38, 83, "Text"],

Cell[CellGroupData[{
Cell[111891, 3842, 51, 1, 51, "Input"],
Cell[111945, 3845, 171, 3, 51, "Message"]
}, Closed]],

Cell[CellGroupData[{
Cell[112153, 3853, 56, 1, 51, "Input"],
Cell[112212, 3856, 4171, 133, 255, "Output"]
}, Closed]],
Cell[116398, 3992, 889, 32, 58, "Text"],

Cell[CellGroupData[{
Cell[117312, 4028, 82, 1, 51, "Input"],
Cell[117397, 4031, 7309, 229, 411, "Output"]
}, Closed]],
Cell[124721, 4263, 769, 24, 79, "Text"],

Cell[CellGroupData[{
Cell[125515, 4291, 84, 1, 51, "Input"],
Cell[125602, 4294, 6617, 207, 325, "Output"]
}, Closed]],
Cell[132234, 4504, 580, 17, 58, "Text"],

Cell[CellGroupData[{
Cell[132839, 4525, 191, 5, 51, "Input"],
Cell[133033, 4532, 8082, 258, 383, "Output"]
}, Closed]],
Cell[141130, 4793, 158, 6, 33, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[141325, 4804, 64, 1, 39, "Subsection",
  CellTags->"ZonalHarmonic"],
Cell[141392, 4807, 287, 10, 37, "Text"],

Cell[CellGroupData[{
Cell[141704, 4821, 51, 1, 51, "Input"],
Cell[141758, 4824, 171, 3, 51, "Message"]
}, Closed]],

Cell[CellGroupData[{
Cell[141966, 4832, 55, 1, 51, "Input"],
Cell[142024, 4835, 513, 9, 112, "Output"]
}, Closed]],
Cell[142552, 4847, 769, 27, 58, "Text"],

Cell[CellGroupData[{
Cell[143346, 4878, 51, 1, 51, "Input"],
Cell[143400, 4881, 171, 3, 51, "Message"]
}, Closed]],

Cell[CellGroupData[{
Cell[143608, 4889, 138, 3, 51, "Input"],
Cell[143749, 4894, 317, 6, 74, "Output"]
}, Closed]],
Cell[144081, 4903, 741, 24, 58, "Text"],

Cell[CellGroupData[{
Cell[144847, 4931, 217, 4, 51, "Input"],
Cell[145067, 4937, 153, 2, 74, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[145269, 4945, 58, 1, 39, "Subsection",
  CellTags->"DimensionH"],
Cell[145330, 4948, 628, 21, 37, "Text"],

Cell[CellGroupData[{
Cell[145983, 4973, 52, 1, 51, "Input"],
Cell[146038, 4976, 50, 1, 60, "Output"]
}, Closed]],
Cell[146103, 4980, 196, 7, 37, "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[146348, 4993, 103, 1, 44, "Section",
  CellTags->"Inversion and the Kelvin Transform"],

Cell[CellGroupData[{
Cell[146476, 4998, 57, 1, 66, "Subsection",
  CellTags->"Inversion"],
Cell[146536, 5001, 603, 18, 67, "Text"],

Cell[CellGroupData[{
Cell[147164, 5023, 53, 1, 51, "Input"],
Cell[147220, 5026, 114, 2, 77, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[147371, 5033, 65, 1, 51, "Input"],
Cell[147439, 5036, 76, 1, 74, "Output"]
}, Closed]],
Cell[147530, 5040, 524, 17, 62, "Text"],

Cell[CellGroupData[{
Cell[148079, 5061, 86, 1, 51, "Input"],
Cell[148168, 5064, 68, 1, 74, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[148273, 5070, 71, 1, 51, "Input"],
Cell[148347, 5073, 135, 2, 96, "Output"]
}, Closed]],
Cell[148497, 5078, 208, 7, 37, "Text"],
Cell[148708, 5087, 1186, 40, 104, "Text"],

Cell[CellGroupData[{
Cell[149919, 5131, 80, 1, 51, "Input"],
Cell[150002, 5134, 191, 3, 93, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[150230, 5142, 84, 1, 51, "Input"],
Cell[150317, 5145, 117, 2, 93, "Output"]
}, Closed]],
Cell[150449, 5150, 220, 7, 37, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[150706, 5162, 50, 1, 66, "Subsection",
  CellTags->"Kelvin"],
Cell[150759, 5165, 242, 9, 37, "Text"],

Cell[CellGroupData[{
Cell[151026, 5178, 51, 1, 51, "Input"],
Cell[151080, 5181, 171, 3, 51, "Message"]
}, Closed]],

Cell[CellGroupData[{
Cell[151288, 5189, 77, 1, 51, "Input"],
Cell[151368, 5192, 199, 3, 79, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[151616, 5201, 44, 1, 66, "Subsection",
  CellTags->"Phi"],
Cell[151663, 5204, 268, 7, 37, "Text"],
Cell[151934, 5213, 725, 23, 43, "Text"],
Cell[152662, 5238, 304, 7, 55, "Text"],
Cell[152969, 5247, 319, 12, 33, "Text"],

Cell[CellGroupData[{
Cell[153313, 5263, 49, 1, 51, "Input"],
Cell[153365, 5266, 182, 3, 51, "Message"],
Cell[153550, 5271, 131, 2, 96, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[153718, 5278, 49, 1, 51, "Input"],
Cell[153770, 5281, 35, 1, 79, "Output"]
}, Closed]],
Cell[153820, 5285, 605, 22, 58, "Text"],
Cell[154428, 5309, 196, 6, 33, "Text"],
Cell[154627, 5317, 415, 14, 44, "Text"],

Cell[CellGroupData[{
Cell[155067, 5335, 52, 1, 51, "Input"],
Cell[155122, 5338, 239, 4, 96, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[155398, 5347, 96, 2, 51, "Input"],
Cell[155497, 5351, 125, 2, 96, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[155671, 5359, 52, 1, 66, "Subsection",
  CellTags->"KelvinM"],
Cell[155726, 5362, 132, 3, 37, "Text"],
Cell[155861, 5367, 463, 11, 30, "Text"],
Cell[156327, 5380, 272, 7, 54, "Text"],

Cell[CellGroupData[{
Cell[156624, 5391, 51, 1, 51, "Input"],
Cell[156678, 5394, 171, 3, 51, "Message"]
}, Closed]],

Cell[CellGroupData[{
Cell[156886, 5402, 49, 1, 51, "Input"],
Cell[156938, 5405, 243, 4, 96, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[157218, 5414, 48, 1, 51, "Input"],
Cell[157269, 5417, 197, 3, 96, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[157503, 5425, 47, 1, 51, "Input"],
Cell[157553, 5428, 38, 1, 79, "Output"]
}, Closed]],
Cell[157606, 5432, 644, 25, 58, "Text"],

Cell[CellGroupData[{
Cell[158275, 5461, 55, 1, 51, "Input"],
Cell[158333, 5464, 184, 3, 51, "Message"]
}, Closed]],

Cell[CellGroupData[{
Cell[158554, 5472, 52, 1, 51, "Input"],
Cell[158609, 5475, 148, 2, 80, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[158794, 5482, 49, 1, 51, "Input"],
Cell[158846, 5485, 247, 4, 84, "Output"]
}, Closed]],
Cell[159108, 5492, 1222, 39, 105, "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[160379, 5537, 49, 1, 44, "Section",
  CellTags->"Kernels"],

Cell[CellGroupData[{
Cell[160453, 5542, 64, 1, 66, "Subsection",
  CellTags->"PoissonKernel"],
Cell[160520, 5545, 411, 16, 37, "Text"],

Cell[CellGroupData[{
Cell[160956, 5565, 51, 1, 51, "Input"],
Cell[161010, 5568, 171, 3, 51, "Message"]
}, Closed]],

Cell[CellGroupData[{
Cell[161218, 5576, 52, 1, 51, "Input"],
Cell[161273, 5579, 321, 5, 80, "Output"]
}, Closed]],
Cell[161609, 5587, 318, 10, 33, "Text"],

Cell[CellGroupData[{
Cell[161952, 5601, 149, 3, 51, "Input"],
Cell[162104, 5606, 207, 4, 80, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[162360, 5616, 67, 1, 66, "Subsection",
  CellTags->"PoisssonKernelH"],
Cell[162430, 5619, 479, 19, 58, "Text"],

Cell[CellGroupData[{
Cell[162934, 5642, 51, 1, 51, "Input"],
Cell[162988, 5645, 171, 3, 51, "Message"]
}, Closed]],

Cell[CellGroupData[{
Cell[163196, 5653, 53, 1, 51, "Input"],
Cell[163252, 5656, 247, 4, 97, "Output"]
}, Closed]],
Cell[163514, 5663, 579, 22, 54, "Text"],

Cell[CellGroupData[{
Cell[164118, 5689, 56, 1, 51, "Input"],
Cell[164177, 5692, 218, 4, 97, "Output"]
}, Closed]],
Cell[164410, 5699, 1213, 50, 80, "Text"],

Cell[CellGroupData[{
Cell[165648, 5753, 55, 1, 51, "Input"],
Cell[165706, 5756, 184, 3, 51, "Message"]
}, Closed]],

Cell[CellGroupData[{
Cell[165927, 5764, 59, 1, 51, "Input"],
Cell[165989, 5767, 179, 3, 100, "Output"]
}, Closed]],
Cell[166183, 5773, 633, 26, 38, "Text"],

Cell[CellGroupData[{
Cell[166841, 5803, 59, 1, 51, "Input"],
Cell[166903, 5806, 159, 3, 100, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[167111, 5815, 64, 1, 66, "Subsection",
  CellTags->"BergmanKernel"],
Cell[167178, 5818, 159, 4, 37, "Text"],

Cell[CellGroupData[{
Cell[167362, 5826, 52, 1, 51, "Input"],
Cell[167417, 5829, 172, 3, 51, "Message"]
}, Closed]],

Cell[CellGroupData[{
Cell[167626, 5837, 52, 1, 51, "Input"],
Cell[167681, 5840, 484, 7, 100, "Output"]
}, Closed]],
Cell[168180, 5850, 193, 7, 37, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[168410, 5862, 66, 1, 66, "Subsection",
  CellTags->"BergmanKernelH"],
Cell[168479, 5865, 167, 4, 37, "Text"],

Cell[CellGroupData[{
Cell[168671, 5873, 52, 1, 51, "Input"],
Cell[168726, 5876, 172, 3, 51, "Message"]
}, Closed]],

Cell[CellGroupData[{
Cell[168935, 5884, 53, 1, 51, "Input"],
Cell[168991, 5887, 408, 6, 100, "Output"]
}, Closed]],
Cell[169414, 5896, 1198, 47, 84, "Text"],

Cell[CellGroupData[{
Cell[170637, 5947, 55, 1, 51, "Input"],
Cell[170695, 5950, 184, 3, 51, "Message"]
}, Closed]],

Cell[CellGroupData[{
Cell[170916, 5958, 59, 1, 51, "Input"],
Cell[170978, 5961, 284, 5, 105, "Output"]
}, Closed]],
Cell[171277, 5969, 197, 7, 37, "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[171523, 5982, 61, 1, 44, "Section",
  CellTags->"Miscellaneous"],

Cell[CellGroupData[{
Cell[171609, 5987, 72, 1, 66, "Subsection",
  CellTags->"BergmanProjection"],
Cell[171684, 5990, 538, 19, 58, "Text"],

Cell[CellGroupData[{
Cell[172247, 6013, 51, 1, 51, "Input"],
Cell[172301, 6016, 171, 3, 51, "Message"]
}, Closed]],

Cell[CellGroupData[{
Cell[172509, 6024, 71, 1, 51, "Input"],
Cell[172583, 6027, 973, 17, 172, "Output"]
}, Closed]],
Cell[173571, 6047, 202, 7, 37, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[173810, 6059, 72, 1, 66, "Subsection",
  CellTags->"HarmonicConjugate"],
Cell[173885, 6062, 880, 35, 58, "Text"],

Cell[CellGroupData[{
Cell[174790, 6101, 114, 2, 51, "Input"],
Cell[174907, 6105, 110, 2, 79, "Output"]
}, Closed]],
Cell[175032, 6110, 212, 7, 37, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[175281, 6122, 52, 1, 66, "Subsection",
  CellTags->"Schwarz"],
Cell[175336, 6125, 926, 29, 104, "Text"],

Cell[CellGroupData[{
Cell[176287, 6158, 51, 1, 51, "Input"],
Cell[176341, 6161, 171, 3, 51, "Message"]
}, Closed]],

Cell[CellGroupData[{
Cell[176549, 6169, 43, 1, 51, "Input"],
Cell[176595, 6172, 598, 9, 104, "Output"]
}, Closed]],
Cell[177208, 6184, 428, 13, 58, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[177673, 6202, 68, 1, 66, "Subsection",
  CellTags->"TurnOff and TurnOn"],
Cell[177744, 6205, 2364, 65, 275, "Text"],
Cell[180111, 6272, 684, 19, 79, "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[180844, 6297, 55, 1, 44, "Section",
  CellTags->"References"],
Cell[180902, 6300, 236, 6, 54, "Text",
  CellTags->"ABR"],
Cell[181141, 6308, 156, 4, 33, "Text",
  CellTags->"AGV"],
Cell[181300, 6314, 255, 7, 54, "Text",
  CellTags->"AR"],
Cell[181558, 6323, 121, 4, 33, "Text",
  CellTags->"R"],
Cell[181682, 6329, 189, 6, 33, "Text",
  CellTags->"W"]
}, Closed]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

